/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.client.Cache;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.client.ICheckedCallable;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerPage;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerWebhook;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

@Extension
public class ServerWebhookManager
extends AbstractWebhookManager<ServerWebhookConfiguration> {
    private static final String WEBHOOK_API = "/rest/api/1.0/projects/{owner}/repos/{repo}/webhooks{/id}{?start,limit}";
    private static final Logger logger = Logger.getLogger(ServerWebhookManager.class.getName());
    private static final Cache<String, List<BitbucketWebHook>> cachedRepositoryWebhooks = new Cache(3, TimeUnit.HOURS);
    private static final List<String> NATIVE_SERVER_EVENTS = Collections.unmodifiableList(Arrays.asList(HookEventType.SERVER_REFS_CHANGED.getKey(), HookEventType.SERVER_PULL_REQUEST_OPENED.getKey(), HookEventType.SERVER_PULL_REQUEST_MERGED.getKey(), HookEventType.SERVER_PULL_REQUEST_DECLINED.getKey(), HookEventType.SERVER_PULL_REQUEST_DELETED.getKey(), HookEventType.SERVER_PULL_REQUEST_MODIFIED.getKey(), HookEventType.SERVER_MIRROR_REPO_SYNCHRONIZED.getKey(), HookEventType.SERVER_PULL_REQUEST_FROM_REF_UPDATED.getKey()));
    private String serverURL;

    public static void clearCaches() {
        cachedRepositoryWebhooks.evictAll();
    }

    public static List<String> stats() {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add("Repositories webhooks: " + cachedRepositoryWebhooks.stats().toString());
        return stats;
    }

    @Override
    public void setCallbackURL(@NonNull String callbackURL, @NonNull BitbucketEndpoint endpoint) {
        this.serverURL = endpoint.getServerURL();
        this.callbackURL = UriTemplate.buildFromTemplate((String)callbackURL).query(new String[]{"server_url"}).build().set("server_url", (Object)this.serverURL).expand();
    }

    @Override
    public void apply(BitbucketWebhookConfiguration configuration) {
        super.apply(configuration);
        if (((ServerWebhookConfiguration)this.configuration).isEnableCache()) {
            cachedRepositoryWebhooks.setExpireDuration(((ServerWebhookConfiguration)this.configuration).getWebhooksCacheDuration(), TimeUnit.MINUTES);
        }
    }

    @Override
    @NonNull
    public Collection<BitbucketWebHook> read(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        String endpointJenkinsRootURL = this.getEndpointJenkinsRootURL();
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("start", (Object)0).set("limit", (Object)200).expand();
        ICheckedCallable request = () -> {
            TypeReference<BitbucketServerPage<BitbucketServerWebhook>> type = new TypeReference<BitbucketServerPage<BitbucketServerWebhook>>(){};
            return JsonParser.toJava(client.get(url), type).getValues().stream().map(BitbucketWebHook.class::cast).filter(hook -> hook.getUrl().startsWith(endpointJenkinsRootURL)).toList();
        };
        if (this.isCacheEnabled(client)) {
            try {
                String cacheKey = this.buildCacheKey(client);
                return cachedRepositoryWebhooks.get(cacheKey, request);
            }
            catch (ExecutionException e) {
                BitbucketRequestException bre = BitbucketApiUtils.unwrap(e);
                if (bre != null) {
                    throw bre;
                }
                throw new IOException(e);
            }
        }
        return request.call();
    }

    @NonNull
    private BitbucketServerWebhook buildPayload() {
        BitbucketServerWebhook hook = new BitbucketServerWebhook();
        hook.setActive(true);
        hook.setDescription("Jenkins hook");
        hook.setEvents(NATIVE_SERVER_EVENTS);
        hook.setUrl(this.callbackURL);
        hook.setSslVerificationRequired(!((ServerWebhookConfiguration)this.configuration).isSkipCertVerification());
        if (((ServerWebhookConfiguration)this.configuration).isEnableHookSignature()) {
            String signatureCredentialsId = ((ServerWebhookConfiguration)this.configuration).getHookSignatureCredentialsId();
            StringCredentials signatureSecret = BitbucketCredentialsUtils.lookupCredentials(Jenkins.get(), this.serverURL, signatureCredentialsId, StringCredentials.class);
            if (signatureSecret != null) {
                hook.setSecret(Secret.toString((Secret)signatureSecret.getSecret()));
            } else {
                throw new IllegalStateException("Credentials " + signatureCredentialsId + " not found on hook registration");
            }
        }
        return hook;
    }

    private void register(@NonNull BitbucketServerWebhook payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).expand();
        client.post(url, JsonParser.toString(payload));
        if (this.isCacheEnabled(client)) {
            String cacheKey = this.buildCacheKey(client);
            cachedRepositoryWebhooks.evict(cacheKey);
        }
    }

    private boolean shouldUpdate(@NonNull BitbucketServerWebhook current, @NonNull BitbucketServerWebhook expected) {
        List<String> expectedEvents;
        List<String> events;
        boolean update = false;
        if (!Objects.equal((Object)current.getUrl(), (Object)expected.getUrl())) {
            current.setUrl(expected.getUrl());
            logger.info(() -> "Update webhook " + current.getUuid() + " callback URL");
            update = true;
        }
        if (!current.isActive()) {
            current.setActive(true);
            logger.info(() -> "Re-activate webhook " + current.getUuid());
            update = true;
        }
        if (current.isSslVerificationRequired() != expected.isSslVerificationRequired()) {
            current.setSslVerificationRequired(expected.isSslVerificationRequired());
            logger.info(() -> "Update webhook sslVerificationRequired " + expected.isSslVerificationRequired());
            update = true;
        }
        if (!(events = current.getEvents()).containsAll(expectedEvents = expected.getEvents())) {
            TreeSet<String> newEvents = new TreeSet<String>(events);
            newEvents.addAll(expectedEvents);
            current.setEvents(new ArrayList<String>(newEvents));
            logger.info(() -> "Update webhook " + current.getUuid() + " events because was missing: " + CollectionUtils.subtract((Collection)expectedEvents, (Collection)events));
            update = true;
        }
        if (!Objects.equal((Object)current.getSecret(), (Object)expected.getSecret())) {
            current.setSecret(expected.getSecret());
            logger.info(() -> "Update webhook " + current.getUuid() + " signature secret");
            update = true;
        }
        return update;
    }

    private void update(@NonNull BitbucketServerWebhook payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("id", (Object)payload.getUuid()).expand();
        client.put(url, JsonParser.toString(payload));
        if (this.isCacheEnabled(client)) {
            String cacheKey = this.buildCacheKey(client);
            cachedRepositoryWebhooks.evict(cacheKey);
        }
    }

    @Override
    public void remove(@NonNull String webhookId, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("id", (Object)webhookId).expand();
        client.delete(url);
    }

    @Override
    public void register(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        BitbucketServerWebhook existingHook = this.read(client).stream().findFirst().orElse(null);
        if (existingHook == null) {
            logger.log(Level.INFO, "Registering server hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.register(this.buildPayload(), client);
        } else if (this.shouldUpdate(existingHook, this.buildPayload())) {
            logger.log(Level.INFO, "Updating server hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.update(existingHook, client);
        }
    }
}

