/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.util.Secret;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.utils.Base64;
import org.apache.hc.core5.http.HttpRequest;

public class BitbucketUsernamePasswordAuthenticator
implements BitbucketAuthenticator {
    private final String encodedAuth;
    private final String credentialsId;

    public BitbucketUsernamePasswordAuthenticator(StandardUsernamePasswordCredentials credentials) {
        this.credentialsId = credentials.getId();
        String password = Secret.toString((Secret)credentials.getPassword());
        String auth = credentials.getUsername() + ":" + password;
        this.encodedAuth = Base64.encodeBase64String((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
    }

    @Override
    public void configureRequest(HttpRequest request) {
        String authHeader = "Basic " + this.encodedAuth;
        request.setHeader("Authorization", (Object)authHeader);
    }

    @Override
    public String getId() {
        return this.credentialsId;
    }
}

