/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.avatars;

import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.impl.avatars.BitbucketAvatarImageSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import java.util.Objects;
import jenkins.scm.api.metadata.AvatarMetadataAction;
import jenkins.scm.impl.avatars.AvatarCache;
import jenkins.scm.impl.avatars.AvatarImageSource;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketTeamAvatarMetadataAction
extends AvatarMetadataAction {
    private static final long serialVersionUID = -7472619697440514373L;
    private final String avatarURL;
    private final String serverURL;
    private final String scmOwner;
    private final String credentialsId;

    @DataBoundConstructor
    public BitbucketTeamAvatarMetadataAction(@Nullable String avatarURL, @NonNull String serverURL, @NonNull String scmOwner, @Nullable String credentialsId) {
        this.avatarURL = Util.fixEmptyAndTrim((String)avatarURL);
        this.serverURL = Util.fixEmptyAndTrim((String)serverURL);
        this.scmOwner = Util.fixEmptyAndTrim((String)scmOwner);
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public String getAvatarImageOf(String size) {
        if (this.avatarURL == null) {
            return super.getAvatarImageOf(size);
        }
        return AvatarCache.buildUrl((AvatarImageSource)new BitbucketAvatarImageSource(this.avatarURL, this.serverURL, this.scmOwner, this.credentialsId), (String)size);
    }

    public String getAvatarIconClassName() {
        return this.avatarURL == null ? "icon-bitbucket-logo" : null;
    }

    public String getAvatarDescription() {
        return Messages.BitbucketTeamMetadataAction_IconDescription();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BitbucketTeamAvatarMetadataAction other = (BitbucketTeamAvatarMetadataAction)((Object)obj);
        return Objects.equals(this.avatarURL, other.avatarURL) && Objects.equals(this.serverURL, other.serverURL) && Objects.equals(this.scmOwner, other.scmOwner) && Objects.equals(this.credentialsId, other.credentialsId);
    }

    public int hashCode() {
        return Objects.hash(this.avatarURL, this.serverURL, this.scmOwner, this.credentialsId);
    }
}

