/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessorException;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.Secret;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Strings;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractWebhookProcessor
implements BitbucketWebhookProcessor {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected static final String REQUEST_ID_CLOUD_HEADER = "X-Request-UUID";
    protected static final String REQUEST_ID_SERVER_HEADER = "X-Request-Id";
    protected static final String SIGNATURE_HEADER = "X-Hub-Signature";
    protected static final String EVENT_TYPE_HEADER = "X-Event-Key";
    protected static final String SERVER_URL_PARAMETER = "server_url";

    protected void scmSourceReIndex(String owner, String repository, String mirrorId) {
        try (ACLContext context = ACL.as2((Authentication)ACL.SYSTEM2);){
            boolean reindexed = false;
            for (SCMSourceOwner scmOwner : SCMSourceOwners.all()) {
                List sources = scmOwner.getSCMSources();
                for (SCMSource source : sources) {
                    BitbucketSCMSource scmSource;
                    if (!(source instanceof BitbucketSCMSource) || !Strings.CI.equals((scmSource = (BitbucketSCMSource)source).getRepoOwner(), owner) || !scmSource.getRepository().equals(repository) || mirrorId != null && !Strings.CI.equals(mirrorId, scmSource.getMirrorId())) continue;
                    this.logger.log(Level.INFO, "Multibranch project found, reindexing {0}", scmOwner.getName());
                    scmOwner.onSCMSourceUpdated(source);
                    reindexed = true;
                }
            }
            if (!reindexed) {
                this.logger.log(Level.INFO, "No multibranch project matching for reindex on {0}/{1}", new Object[]{owner, repository});
            }
        }
    }

    @Override
    @NonNull
    public String getServerURL(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        String serverURL = parameters.get((Object)SERVER_URL_PARAMETER).stream().findFirst().orElse(null);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)serverURL)) {
            throw new BitbucketWebhookProcessorException(400, "server_url query parameter not found or empty. Refer to the user documentation on how configure the webHook in Bitbucket at https://github.com/jenkinsci/bitbucket-branch-source-plugin/blob/master/docs/USER_GUIDE.adoc#webhooks-registering");
        }
        return serverURL;
    }

    @Override
    @NonNull
    public String getEventType(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        String eventType = headers.get(EVENT_TYPE_HEADER);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)eventType)) {
            throw new IllegalStateException("X-Event-Key is missing or empty, this processor should not proceed after canHandle method. Please fill an issue at https://issues.jenkins.io reporting this stacktrace.");
        }
        return eventType;
    }

    @Override
    public void verifyPayload(@NonNull Map<String, String> headers, @NonNull String body, @NonNull BitbucketEndpoint endpoint) throws BitbucketWebhookProcessorException {
        BitbucketWebhookConfiguration webhook = endpoint.getWebhook();
        boolean signatureEnabled = false;
        String signatureCredentialsId = null;
        if (webhook instanceof CloudWebhookConfiguration) {
            CloudWebhookConfiguration cloud = (CloudWebhookConfiguration)webhook;
            signatureEnabled = cloud.isEnableHookSignature();
            signatureCredentialsId = cloud.getHookSignatureCredentialsId();
        } else if (webhook instanceof ServerWebhookConfiguration) {
            ServerWebhookConfiguration server = (ServerWebhookConfiguration)webhook;
            signatureEnabled = server.isEnableHookSignature();
            signatureCredentialsId = server.getHookSignatureCredentialsId();
        } else {
            this.logger.warning(() -> "Webhook implementation " + webhook.getId() + " not supported for payload verification, it should implements also an own WebookProcessor");
        }
        if (signatureEnabled && !headers.containsKey(SIGNATURE_HEADER)) {
            throw new BitbucketWebhookProcessorException(403, "Payload has not be signed, configure the webHook secret in Bitbucket as documented at https://github.com/jenkinsci/bitbucket-branch-source-plugin/blob/master/docs/USER_GUIDE.adoc#webhooks-registering");
        }
        if (signatureEnabled && signatureCredentialsId != null) {
            StringCredentials signatureCredentials = this.lookupCredentials(signatureCredentialsId, endpoint.getServerURL());
            if (signatureCredentials == null) {
                String hookId = headers.get("X-Hook-UUID");
                String requestId = (String)ObjectUtils.firstNonNull((Object[])new String[]{headers.get(REQUEST_ID_CLOUD_HEADER), headers.get(REQUEST_ID_SERVER_HEADER)});
                this.logger.log(Level.WARNING, "No credentials {0} found to verify the signature of incoming webhook {1} request {2}", new Object[]{signatureCredentialsId, hookId, requestId});
                throw new BitbucketWebhookProcessorException(403, "No credentials " + signatureCredentialsId + " found in Jenkins to verify the signature");
            }
            this.verifyPayload(headers, body, signatureCredentials);
        }
    }

    StringCredentials lookupCredentials(@NonNull String signatureCredentialsId, @Nullable String serverURL) {
        return BitbucketCredentialsUtils.lookupCredentials(Jenkins.get(), serverURL, signatureCredentialsId, StringCredentials.class);
    }

    private void verifyPayload(@NonNull Map<String, String> headers, @NonNull String body, @NonNull StringCredentials signatureCredentials) {
        String signatureHeader = headers.get(SIGNATURE_HEADER);
        String bitbucketAlgorithm = StringUtils.trimToNull((String)org.apache.commons.lang3.StringUtils.substringBefore((String)signatureHeader, (String)"="));
        String bitbucketSignature = StringUtils.trimToNull((String)org.apache.commons.lang3.StringUtils.substringAfter((String)signatureHeader, (String)"="));
        HmacAlgorithms algorithm = this.getAlgorithm(bitbucketAlgorithm);
        if (algorithm == null) {
            throw new BitbucketWebhookProcessorException(403, "Signature " + bitbucketAlgorithm + " not supported");
        }
        try {
            String key = Secret.toString((Secret)signatureCredentials.getSecret());
            HmacUtils util = new HmacUtils(algorithm, key.getBytes(StandardCharsets.UTF_8));
            byte[] digest = util.hmac(body);
            if (!MessageDigest.isEqual(Hex.decodeHex((String)bitbucketSignature), digest)) {
                throw new BitbucketWebhookProcessorException(403, "Signature verification failed");
            }
        }
        catch (IllegalArgumentException e) {
            throw new BitbucketWebhookProcessorException(400, "Signature method not supported: " + algorithm);
        }
        catch (DecoderException e) {
            throw new BitbucketWebhookProcessorException(400, "Hex signature can not be decoded: " + bitbucketSignature);
        }
    }

    protected String getOrigin(Map<String, Object> context) {
        return (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{(String)context.get("origin"), "unknow"});
    }

    @CheckForNull
    private HmacAlgorithms getAlgorithm(String algorithm) {
        switch (org.apache.commons.lang3.StringUtils.lowerCase((String)algorithm)) {
            case "sha1": {
                return HmacAlgorithms.HMAC_SHA_1;
            }
            case "sha256": {
                return HmacAlgorithms.HMAC_SHA_256;
            }
            case "sha384": {
                return HmacAlgorithms.HMAC_SHA_384;
            }
            case "sha512": {
                return HmacAlgorithms.HMAC_SHA_512;
            }
        }
        return null;
    }
}

