/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.webhook;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessorException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.util.SystemProperties;
import org.apache.commons.collections4.MultiValuedMap;

public interface BitbucketWebhookProcessor
extends ExtensionPoint {
    public static final String SCAN_ON_EMPTY_CHANGES_PROPERTY_NAME = "bitbucket.hooks.processor.scanOnEmptyChanges";

    public boolean canHandle(@NonNull Map<String, String> var1, @NonNull MultiValuedMap<String, String> var2);

    @NonNull
    public String getServerURL(@NonNull Map<String, String> var1, @NonNull MultiValuedMap<String, String> var2);

    @NonNull
    public String getEventType(Map<String, String> var1, MultiValuedMap<String, String> var2);

    @NonNull
    default public Map<String, Object> buildHookContext(@NonNull HttpServletRequest request) {
        return Map.of("origin", SCMEvent.originOf((HttpServletRequest)request));
    }

    public void verifyPayload(@NonNull Map<String, String> var1, @NonNull String var2, @NonNull BitbucketEndpoint var3) throws BitbucketWebhookProcessorException;

    default public boolean reindexOnEmptyChanges() {
        return SystemProperties.getBoolean((String)SCAN_ON_EMPTY_CHANGES_PROPERTY_NAME, (boolean)false);
    }

    public void process(@NonNull String var1, @NonNull String var2, @NonNull Map<String, Object> var3, @NonNull BitbucketEndpoint var4);

    default public void notifyEvent(SCMHeadEvent<?> event, int delaySeconds) {
        if (delaySeconds == 0) {
            SCMHeadEvent.fireNow(event);
        } else {
            SCMHeadEvent.fireLater(event, (long)(delaySeconds > 0 ? (long)delaySeconds : (long)BitbucketSCMSource.getEventDelaySeconds()), (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

