/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentialsUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractBitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerWebhookManager;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ServerWebhookConfiguration
extends AbstractBitbucketWebhookConfiguration {
    public ServerWebhookConfiguration(boolean manageHooks, @CheckForNull String credentialsId) {
        super(manageHooks, credentialsId, false, null);
    }

    @DataBoundConstructor
    public ServerWebhookConfiguration(boolean manageHooks, @CheckForNull String credentialsId, boolean enableHookSignature, @CheckForNull String hookSignatureCredentialsId) {
        super(manageHooks, credentialsId, enableHookSignature, hookSignatureCredentialsId);
    }

    @Override
    public String getDisplayName() {
        return Messages.ServerWebhookImplementation_displayName();
    }

    @Override
    @NonNull
    public String getId() {
        return "SERVER_NATIVE";
    }

    @Override
    public Class<? extends BitbucketWebhookManager> getManager() {
        return ServerWebhookManager.class;
    }

    @Symbol(value={"serverWebhook"})
    @Extension
    public static class DescriptorImpl
    extends AbstractBitbucketWebhookConfiguration.AbstractBitbucketWebhookDescriptorImpl {
        public String getDisplayName() {
            return "Native Data Center";
        }

        @Override
        public boolean isApplicable(@NonNull EndpointType type) {
            return type == EndpointType.SERVER;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter(fixEmpty=true) String credentialsId, @QueryParameter(value="serverURL", fixEmpty=true) String serverURL) {
            Jenkins jenkins = DescriptorImpl.checkPermission();
            return BitbucketCredentialsUtils.listCredentials(jenkins, serverURL, credentialsId);
        }

        @RequirePOST
        public ListBoxModel doFillHookSignatureCredentialsIdItems(@QueryParameter(fixEmpty=true) String hookSignatureCredentialsId, @QueryParameter(value="serverURL", fixEmpty=true) String serverURL) {
            return super.getHookSignatureCredentialsIdItems(hookSignatureCredentialsId, serverURL);
        }
    }
}

