/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.BitbucketCloudEndpoint;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;

@Extension
public class BitbucketCloudApiFactory
extends BitbucketApiFactory {
    @Override
    protected boolean isMatch(@Nullable String serverUrl) {
        return serverUrl == null || "https://bitbucket.org".equals(serverUrl);
    }

    @Override
    @NonNull
    protected BitbucketApi create(@Nullable String serverUrl, @Nullable BitbucketAuthenticator authenticator, @NonNull String owner, @CheckForNull String projectKey, @CheckForNull String repository) {
        BitbucketCloudEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint("https://bitbucket.org", BitbucketCloudEndpoint.class).orElse(null);
        boolean enableCache = false;
        int teamCacheDuration = 0;
        int repositoriesCacheDuration = 0;
        if (endpoint != null) {
            enableCache = endpoint.isEnableCache();
            teamCacheDuration = endpoint.getTeamCacheDuration();
            repositoriesCacheDuration = endpoint.getRepositoriesCacheDuration();
        }
        return new BitbucketCloudApiClient(enableCache, teamCacheDuration, repositoriesCacheDuration, owner, projectKey, repository, authenticator);
    }
}

