/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.trait;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceRequest;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.trait.BitbucketSCMSourceTraitDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.IOException;
import java.sql.Date;
import java.time.LocalDate;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.trait.SCMHeadFilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DiscardOldBranchTrait
extends SCMSourceTrait {
    private int keepForDays = 1;

    @DataBoundConstructor
    public DiscardOldBranchTrait(@CheckForNull int keepForDays) {
        this.keepForDays = keepForDays;
    }

    public int getKeepForDays() {
        return this.keepForDays;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        context.withFilter((SCMHeadFilter)new ExcludeOldSCMHeadBranch(this.keepForDays));
    }

    public static final class ExcludeOldSCMHeadBranch
    extends SCMHeadFilter {
        private int keepForDays;

        public ExcludeOldSCMHeadBranch(int keepForDays) {
            this.keepForDays = keepForDays;
        }

        public boolean isExcluded(SCMSourceRequest request, SCMHead head) throws IOException, InterruptedException {
            if (this.keepForDays > 0) {
                BitbucketSCMSourceRequest bbRequest = (BitbucketSCMSourceRequest)request;
                String branchName = head.getName();
                if (head instanceof PullRequestSCMHead) {
                    PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                    branchName = prHead.getBranchName();
                }
                for (BitbucketBranch branch : bbRequest.getBranches()) {
                    if (!branchName.equals(branch.getName())) continue;
                    LocalDate commitDate = this.asLocalDate(branch.getDateMillis());
                    LocalDate expiryDate = LocalDate.now().minusDays(this.keepForDays);
                    return commitDate.isBefore(expiryDate);
                }
            }
            return false;
        }

        @NonNull
        private LocalDate asLocalDate(@NonNull long milliseconds) {
            return new Date(milliseconds).toLocalDate();
        }
    }

    @Symbol(value={"bitbucketDiscardOldBranch"})
    @Extension
    public static class DescriptorImpl
    extends BitbucketSCMSourceTraitDescriptor {
        public FormValidation doCheckKeepForDays(@QueryParameter int keepForDays) {
            if (keepForDays <= 0) {
                return FormValidation.error((String)Messages.DiscardOldBranchTrait_invalidDays());
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.DiscardOldBranchTrait_displayName();
        }
    }
}

