/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerCommit;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerChange;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerMirrorRepoSynchronizedEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerRefsChangedEvent;
import com.google.common.collect.HashMultimap;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RestrictedSince;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.collections4.MultiValuedMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class ServerPushWebhookProcessor
extends AbstractWebhookProcessor {
    private static final Logger logger = Logger.getLogger(ServerPushWebhookProcessor.class.getName());
    private static final List<String> supportedEvents = List.of(HookEventType.SERVER_REFS_CHANGED.getKey(), HookEventType.SERVER_MIRROR_REPO_SYNCHRONIZED.getKey());

    @Override
    public boolean canHandle(Map<String, String> headers, MultiValuedMap<String, String> parameters) {
        return headers.containsKey("X-Event-Key") && headers.containsKey("X-Request-Id") && supportedEvents.contains(headers.get("X-Event-Key")) && parameters.containsKey((Object)"server_url");
    }

    @Override
    public void process(@NonNull String hookEventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        String mirrorId;
        BitbucketServerCommit refCommit;
        List<NativeServerChange> changes;
        BitbucketServerRepository repository;
        block14: {
            try {
                Object event;
                HookEventType hookEvent = HookEventType.fromString(hookEventType);
                if (hookEvent == HookEventType.SERVER_REFS_CHANGED) {
                    event = JsonParser.toJava(payload, NativeServerRefsChangedEvent.class);
                    repository = ((NativeServerRefsChangedEvent)event).getRepository();
                    changes = ((NativeServerRefsChangedEvent)event).getChanges();
                    refCommit = ((NativeServerRefsChangedEvent)event).getToCommit();
                    mirrorId = null;
                    break block14;
                }
                if (hookEvent == HookEventType.SERVER_MIRROR_REPO_SYNCHRONIZED) {
                    event = JsonParser.toJava(payload, NativeServerMirrorRepoSynchronizedEvent.class);
                    repository = ((NativeServerMirrorRepoSynchronizedEvent)event).getRepository();
                    changes = ((NativeServerMirrorRepoSynchronizedEvent)event).getChanges();
                    refCommit = null;
                    mirrorId = ((NativeServerMirrorRepoSynchronizedEvent)event).getMirrorServer().getId();
                    if (((NativeServerMirrorRepoSynchronizedEvent)event).getRefLimitExceeded()) {
                        String owner = repository.getOwnerName();
                        String repositoryName = repository.getRepositoryName();
                        logger.log(Level.INFO, "Received mirror synchronized event with refLimitExceeded from Bitbucket. Processing with indexing on {0}/{1}. You may skip this scan by adding the system property -D{2}=false on startup.", new Object[]{owner, repositoryName, "bitbucket.hooks.processor.scanOnEmptyChanges"});
                        this.scmSourceReIndex(owner, repositoryName, mirrorId);
                        return;
                    }
                    break block14;
                }
                throw new UnsupportedOperationException("Hook event of type " + hookEventType + " is not supported.\nPlease fill an issue at https://issues.jenkins.io to the bitbucket-branch-source-plugin component.");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can not read hook payload", e);
                return;
            }
        }
        if (changes.isEmpty()) {
            String owner = repository.getOwnerName();
            String repositoryName = repository.getRepositoryName();
            if (this.reindexOnEmptyChanges()) {
                logger.log(Level.INFO, "Received push hook with empty changes from Bitbucket. Processing indexing on {0}/{1}. You may skip this scan by adding the system property -D{2}=false on startup.", new Object[]{owner, repositoryName, "bitbucket.hooks.processor.scanOnEmptyChanges"});
                this.scmSourceReIndex(owner, repositoryName, mirrorId);
            } else {
                logger.log(Level.INFO, "Received push hook with empty changes from Bitbucket for {0}/{1}. Skipping.", new Object[]{owner, repositoryName});
            }
        } else {
            HashMultimap events = HashMultimap.create();
            for (NativeServerChange change : changes) {
                String type = change.getType();
                if ("UPDATE".equals(type)) {
                    events.put((Object)SCMEvent.Type.UPDATED, (Object)change);
                    continue;
                }
                if ("DELETE".equals(type)) {
                    events.put((Object)SCMEvent.Type.REMOVED, (Object)change);
                    continue;
                }
                if ("ADD".equals(type)) {
                    events.put((Object)SCMEvent.Type.CREATED, (Object)change);
                    continue;
                }
                logger.log(Level.INFO, "Unknown change event type of {0} received from Bitbucket Server", type);
            }
            for (SCMEvent.Type type : events.keySet()) {
                ServerPushEvent headEvent = new ServerPushEvent(endpoint.getServerURL(), type, events.get((Object)type), this.getOrigin(context), repository, refCommit, mirrorId);
                this.notifyEvent(headEvent, BitbucketSCMSource.getEventDelaySeconds());
            }
        }
    }
}

