/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentialsUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin.PluginWebhookManager;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Deprecated(since="937.0.0")
public class PluginWebhookConfiguration
implements BitbucketWebhookConfiguration {
    private static final Logger logger = Logger.getLogger(PluginWebhookConfiguration.class.getName());
    private static final String WEBHOOK_API = "/rest/webhook/1.0/projects/{owner}/repos/{repo}/configurations";
    private boolean manageHooks;
    @CheckForNull
    private String credentialsId;
    private String endpointJenkinsRootURL;

    @DataBoundConstructor
    public PluginWebhookConfiguration(boolean manageHooks, @CheckForNull String credentialsId) {
        this.manageHooks = manageHooks && StringUtils.isNotBlank((CharSequence)credentialsId);
        this.credentialsId = manageHooks ? Util.fixEmptyAndTrim((String)credentialsId) : null;
    }

    @Override
    public final boolean isManageHooks() {
        return this.manageHooks;
    }

    @Override
    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public String getEndpointJenkinsRootURL() {
        return this.endpointJenkinsRootURL;
    }

    @DataBoundSetter
    public void setEndpointJenkinsRootURL(@CheckForNull String endpointJenkinsRootURL) {
        this.endpointJenkinsRootURL = Util.fixEmptyAndTrim((String)endpointJenkinsRootURL);
    }

    @Override
    public String getDisplayName() {
        return Messages.PluginWebhookImplementation_displayName();
    }

    @Override
    @NonNull
    public String getId() {
        return "PLUGIN";
    }

    @Override
    public Class<? extends BitbucketWebhookManager> getManager() {
        return PluginWebhookManager.class;
    }

    @Symbol(value={"pluginWebhook"})
    @Extension
    public static class DescriptorImpl
    extends BitbucketWebhookDescriptor {
        public String getDisplayName() {
            return "Post Webhooks for Bitbucket";
        }

        @Override
        public boolean isApplicable(@NonNull EndpointType type) {
            return type == EndpointType.SERVER;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter(fixEmpty=true) String credentialsId, @QueryParameter(value="serverURL", fixEmpty=true) String serverURL) {
            Jenkins jenkins = DescriptorImpl.checkPermission();
            return BitbucketCredentialsUtils.listCredentials(jenkins, serverURL, credentialsId);
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public static FormValidation doCheckEndpointJenkinsRootURL(@QueryParameter String value) {
            DescriptorImpl.checkPermission();
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }

        private static Jenkins checkPermission() {
            Jenkins jenkins = Jenkins.get();
            jenkins.checkPermission(Jenkins.MANAGE);
            return jenkins;
        }
    }
}

