/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.trait;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceRequest;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.trait.BitbucketSCMSourceTraitDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.trait.Discovery;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ForkPullRequestDiscoveryTrait
extends SCMSourceTrait {
    private final int strategyId;
    @NonNull
    private final SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust;

    @DataBoundConstructor
    public ForkPullRequestDiscoveryTrait(int strategyId, @NonNull BitbucketForkTrustPolicy trust) {
        this.strategyId = strategyId;
        this.trust = trust;
    }

    @Deprecated
    public ForkPullRequestDiscoveryTrait(int strategyId, @NonNull SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust) {
        this.strategyId = strategyId;
        this.trust = trust;
    }

    public ForkPullRequestDiscoveryTrait(@NonNull Set<ChangeRequestCheckoutStrategy> strategies, @NonNull SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust) {
        this((strategies.contains(ChangeRequestCheckoutStrategy.MERGE) ? 1 : 0) + (strategies.contains(ChangeRequestCheckoutStrategy.HEAD) ? 2 : 0), trust);
    }

    public int getStrategyId() {
        return this.strategyId;
    }

    @NonNull
    public Set<ChangeRequestCheckoutStrategy> getStrategies() {
        switch (this.strategyId) {
            case 1: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.MERGE);
            }
            case 2: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.HEAD);
            }
            case 3: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.HEAD, ChangeRequestCheckoutStrategy.MERGE);
            }
        }
        return EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    }

    @NonNull
    public SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> getTrust() {
        return this.trust;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        BitbucketSCMSourceContext ctx = (BitbucketSCMSourceContext)context;
        ctx.wantForkPRs(true);
        ctx.withAuthority(this.trust);
        ctx.withForkPRStrategies(this.getStrategies());
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category instanceof ChangeRequestSCMHeadCategory;
    }

    public static class TrustEveryone
    extends BitbucketForkTrustPolicy {
        @DataBoundConstructor
        public TrustEveryone() {
        }

        protected boolean checkTrusted(@NonNull BitbucketSCMSourceRequest request, @NonNull PullRequestSCMHead head) {
            return true;
        }

        @Symbol(value={"bitbucketTrustEveryone"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.ForkPullRequestDiscoveryTrait_everyoneDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static class TrustTeamForks
    extends BitbucketForkTrustPolicy {
        @DataBoundConstructor
        public TrustTeamForks() {
        }

        protected boolean checkTrusted(@NonNull BitbucketSCMSourceRequest request, @NonNull PullRequestSCMHead head) throws IOException, InterruptedException {
            if (!head.getOrigin().equals((Object)SCMHeadOrigin.DEFAULT)) {
                return StringUtils.equalsIgnoreCase((CharSequence)head.getRepoOwner(), (CharSequence)request.getRepoOwner());
            }
            return false;
        }

        @Symbol(value={"bitbucketTrustTeam", "bitbucketTrustProject"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.ForkPullRequestDiscoveryTrait_teamDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static class TrustNobody
    extends BitbucketForkTrustPolicy {
        @DataBoundConstructor
        public TrustNobody() {
        }

        public boolean checkTrusted(@NonNull BitbucketSCMSourceRequest request, @NonNull PullRequestSCMHead head) {
            return false;
        }

        @Symbol(value={"bitbucketTrustNobody"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.ForkPullRequestDiscoveryTrait_nobodyDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static abstract class BitbucketForkTrustPolicy
    extends SCMHeadAuthority<BitbucketSCMSourceRequest, PullRequestSCMHead, PullRequestSCMRevision> {
    }

    @Symbol(value={"bitbucketForkDiscovery"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends BitbucketSCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.ForkPullRequestDiscoveryTrait_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillStrategyIdItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.ForkPullRequestDiscoveryTrait_mergeOnly(), "1");
            result.add(Messages.ForkPullRequestDiscoveryTrait_headOnly(), "2");
            result.add(Messages.ForkPullRequestDiscoveryTrait_headAndMerge(), "3");
            return result;
        }

        @NonNull
        public List<SCMHeadAuthorityDescriptor> getTrustDescriptors() {
            return SCMHeadAuthority._for(BitbucketSCMSourceRequest.class, PullRequestSCMHead.class, PullRequestSCMRevision.class, (Class[])new Class[]{SCMHeadOrigin.Fork.class});
        }

        @NonNull
        public SCMHeadAuthority<?, ?, ?> getDefaultTrust() {
            return new TrustTeamForks();
        }
    }
}

