/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client.branch;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudAuthor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class BitbucketCloudBranch
implements BitbucketBranch {
    private static final Logger LOGGER = Logger.getLogger(BitbucketCloudBranch.class.getName());
    private final String name;
    private long dateInMillis;
    private String hash;
    private String author;
    private String message;
    private Callable<BitbucketCommit> commitClosure;
    private boolean callableInitialised;

    @JsonCreator
    public BitbucketCloudBranch(@JsonProperty(value="name") @NonNull String name, @JsonProperty(value="target") @Nullable Target target, @JsonProperty(value="heads") @Nullable List<Head> heads) {
        this.name = name;
        if (target != null) {
            this.dateInMillis = target.date.getTime();
            this.hash = target.hash;
            this.author = target.author.getRaw();
            this.message = target.message;
        }
    }

    public BitbucketCloudBranch(@NonNull String name, String hash, long dateInMillis) {
        this.name = name;
        this.dateInMillis = dateInMillis;
        this.hash = hash;
    }

    @Override
    public String getRawNode() {
        return this.hash;
    }

    public void setDateMillis(long dateInMillis) {
        if (dateInMillis == 0L) {
            this.initHeadCommitInfo();
        }
        this.dateInMillis = dateInMillis;
    }

    public void setRawNode(String hash) {
        this.hash = hash;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getDateMillis() {
        return this.dateInMillis;
    }

    public boolean isActive() {
        return true;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            this.initHeadCommitInfo();
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getAuthor() {
        if (this.author == null) {
            this.initHeadCommitInfo();
        }
        return this.author;
    }

    public void setAuthor(String authorName) {
        this.author = authorName;
    }

    @Restricted(value={NoExternalUse.class})
    public void setCommitClosure(Callable<BitbucketCommit> commitClosure) {
        this.commitClosure = commitClosure;
    }

    private void initHeadCommitInfo() {
        if (this.callableInitialised || this.commitClosure == null) {
            return;
        }
        this.callableInitialised = true;
        try {
            BitbucketCommit commit = this.commitClosure.call();
            this.dateInMillis = commit.getDateMillis();
            this.message = commit.getMessage();
            this.author = commit.getAuthor();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Could not determine head commit details", e);
            this.dateInMillis = 0L;
        }
    }

    public static class Target {
        private final String hash;
        private final String message;
        private final Date date;
        private final BitbucketCloudAuthor author;

        @JsonCreator
        public Target(@JsonProperty(value="hash") @NonNull String hash, @JsonProperty(value="message") @NonNull String message, @JsonProperty(value="date") @NonNull Date date, @JsonProperty(value="author") @NonNull BitbucketCloudAuthor author) {
            this.hash = hash;
            this.message = message;
            this.author = author;
            this.date = (Date)date.clone();
        }
    }

    @Deprecated
    public static class Head {
        private final String hash;

        @JsonCreator
        public Head(@JsonProperty(value="hash") @NonNull String hash) {
            this.hash = hash;
        }
    }
}

