/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCloudWorkspace;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudPage;
import com.cloudbees.jenkins.plugins.bitbucket.client.Cache;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudBranch;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketCloudPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketCloudPullRequestCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudWebhook;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositorySource;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.cloudbees.jenkins.plugins.bitbucket.impl.buildstatus.CloudBuildStatusNotifier;
import com.cloudbees.jenkins.plugins.bitbucket.impl.client.AbstractBitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.impl.client.ICheckedCallable;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketAccessTokenAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketOAuthAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketUserAPITokenAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketUsernamePasswordAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.impl.Operator;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import jenkins.scm.api.SCMFile;
import jenkins.scm.impl.avatars.AvatarImage;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class BitbucketCloudApiClient
extends AbstractBitbucketApi
implements BitbucketApi {
    private static final HttpHost API_HOST = BitbucketApiUtils.toHttpHost("https://api.bitbucket.org");
    private static final String V2_API_BASE_URL = "https://api.bitbucket.org/2.0/repositories";
    private static final String V2_WORKSPACES_API_BASE_URL = "https://api.bitbucket.org/2.0/workspaces";
    private static final String REPO_URL_TEMPLATE = "https://api.bitbucket.org/2.0/repositories{/owner,repo}";
    private static final int MAX_AVATAR_LENGTH = 16384;
    private static final int MAX_PAGE_LENGTH = 100;
    private static final HttpClientConnectionManager connectionManager = BitbucketCloudApiClient.connectionManagerBuilder().setMaxConnPerRoute(20).setMaxConnTotal(20).build();
    private final CloseableHttpClient client;
    private final String owner;
    private final String projectKey;
    private final String repositoryName;
    private final boolean enableCache;
    private static final Cache<String, BitbucketTeam> cachedTeam = new Cache(6, TimeUnit.HOURS);
    private static final Cache<String, List<BitbucketCloudRepository>> cachedRepositories = new Cache(3, TimeUnit.HOURS);
    private static final Cache<String, BitbucketCloudCommit> cachedCommits = new Cache(24, TimeUnit.HOURS);
    private transient BitbucketRepository cachedRepository;
    private transient String cachedDefaultBranch;

    public static List<String> stats() {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add("Team: " + cachedTeam.stats().toString());
        stats.add("Repositories : " + cachedRepositories.stats().toString());
        stats.add("Commits: " + cachedCommits.stats().toString());
        return stats;
    }

    public static void clearCaches() {
        cachedTeam.evictAll();
        cachedRepositories.evictAll();
        cachedCommits.evictAll();
    }

    public BitbucketCloudApiClient(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, String owner, String projectKey, String repositoryName, BitbucketAuthenticator authenticator) {
        super(authenticator);
        this.owner = owner;
        this.projectKey = projectKey;
        this.repositoryName = repositoryName;
        this.enableCache = enableCache;
        if (enableCache) {
            cachedTeam.setExpireDuration(teamCacheDuration, TimeUnit.MINUTES);
            cachedRepositories.setExpireDuration(repositoriesCacheDuration, TimeUnit.MINUTES);
        }
        this.client = super.setupClientBuilder().build();
    }

    @Override
    protected boolean isSupportedAuthenticator(@CheckForNull BitbucketAuthenticator authenticator) {
        return authenticator == null || authenticator instanceof BitbucketAccessTokenAuthenticator || authenticator instanceof BitbucketOAuthAuthenticator || authenticator instanceof BitbucketUserAPITokenAuthenticator || authenticator instanceof BitbucketUsernamePasswordAuthenticator;
    }

    @Override
    @NonNull
    public String getOwner() {
        return this.owner;
    }

    @Override
    @CheckForNull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @NonNull
    public List<BitbucketCloudPullRequest> getPullRequests() throws IOException {
        int pageLen = 50;
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests{?page,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pagelen", (Object)pageLen).expand();
        List<BitbucketCloudPullRequest> pullRequests = this.getPagedRequest(url, BitbucketCloudPullRequest.class);
        pullRequests.removeIf(this::shouldIgnore);
        for (BitbucketCloudPullRequest pullRequest : pullRequests) {
            this.setupClosureForPRBranch(pullRequest);
        }
        return pullRequests;
    }

    private boolean shouldIgnore(BitbucketPullRequest pr) {
        return pr.getSource().getRepository() == null || pr.getSource().getCommit() == null || pr.getDestination().getBranch() == null || pr.getDestination().getCommit() == null;
    }

    private void setupClosureForPRBranch(BitbucketCloudPullRequest pullRequest) {
        BitbucketCloudBranch branch = pullRequest.getSource().getBranch();
        if (branch != null) {
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
        if ((branch = pullRequest.getDestination().getBranch()) != null) {
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
    }

    @Override
    @NonNull
    public BitbucketPullRequest getPullRequestById(@NonNull Integer id) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests{/id}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("id", (Object)id).expand();
        BitbucketCloudPullRequest pr = this.getRequestAs(url, BitbucketCloudPullRequest.class);
        this.setupClosureForPRBranch(pr);
        return pr;
    }

    @Override
    @NonNull
    public BitbucketRepository getRepository() throws IOException {
        if (this.repositoryName == null) {
            throw new UnsupportedOperationException("Cannot get a repository from an API instance that is not associated with a repository");
        }
        if (!this.enableCache || this.cachedRepository == null) {
            String url = UriTemplate.fromTemplate((String)REPO_URL_TEMPLATE).set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).expand();
            this.cachedRepository = this.getRequestAs(url, BitbucketCloudRepository.class);
        }
        return this.cachedRepository;
    }

    @Override
    public void postCommitComment(@NonNull String hash, @NonNull String comment) throws IOException {
        String path = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit{/hash}/build").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        try {
            this.postRequest(path, Collections.singletonList(new BasicNameValuePair("content", comment)));
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Cannot attach comment to commit, request URL: " + path, e);
        }
    }

    @Override
    public boolean checkPathExists(@NonNull String branchOrHash, @NonNull String path) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path*}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)branchOrHash).set("path", (Object)path.split(Operator.PATH.getSeparator())).expand();
        int status = this.headRequestStatus(url);
        if (200 == status) {
            return true;
        }
        if (404 == status) {
            return false;
        }
        if (403 == status) {
            this.logger.log(Level.FINE, "You currently do not have permissions to pull from repo: {0} at branch {1}", new Object[]{this.repositoryName, branchOrHash});
            return false;
        }
        throw new IOException("Communication error requesting URL: " + path + " status code: " + status);
    }

    @Override
    @CheckForNull
    public String getDefaultBranch() throws IOException {
        if (!this.enableCache || this.cachedDefaultBranch == null) {
            String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/{?fields}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("fields", (Object)"mainbranch.name").expand();
            try {
                Map resp = this.getRequestAs(url, Map.class);
                Map mainbranch = (Map)resp.get("mainbranch");
                if (mainbranch != null) {
                    this.cachedDefaultBranch = (String)mainbranch.get("name");
                }
            }
            catch (FileNotFoundException e) {
                this.logger.log(Level.FINE, "Could not find default branch for {0}/{1}", new Object[]{this.owner, this.repositoryName});
                return null;
            }
        }
        return this.cachedDefaultBranch;
    }

    @Override
    public BitbucketCloudBranch getTag(@NonNull String tagName) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/refs/tags/{name}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("name", (Object)tagName).expand();
        return this.getRequestAs(url, BitbucketCloudBranch.class);
    }

    @NonNull
    public List<BitbucketCloudBranch> getTags() throws IOException {
        return this.getBranchesByRef("/refs/tags");
    }

    @Override
    public BitbucketCloudBranch getBranch(@NonNull String branchName) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/refs/branches/{name}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("name", (Object)branchName).expand();
        return this.getRequestAs(url, BitbucketCloudBranch.class);
    }

    @NonNull
    public List<BitbucketCloudBranch> getBranches() throws IOException {
        return this.getBranchesByRef("/refs/branches");
    }

    public List<BitbucketCloudBranch> getBranchesByRef(String nodePath) throws IOException {
        String url = UriTemplate.fromTemplate((String)(REPO_URL_TEMPLATE + nodePath + "{?pagelen}")).set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pagelen", (Object)100).expand();
        return this.getPagedRequest(url, BitbucketCloudBranch.class).stream().filter(BitbucketCloudBranch::isActive).toList();
    }

    @Override
    @CheckForNull
    public BitbucketCommit resolveCommit(@NonNull String hash) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit/{hash}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        ICheckedCallable request = () -> {
            try {
                return this.getRequestAs(url, BitbucketCloudCommit.class);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        };
        if (this.enableCache) {
            try {
                return cachedCommits.get(hash, request);
            }
            catch (ExecutionException e) {
                BitbucketRequestException bre = BitbucketApiUtils.unwrap(e);
                if (bre != null) {
                    throw bre;
                }
                throw new IOException(e);
            }
        }
        return request.call();
    }

    @Override
    @NonNull
    public String resolveSourceFullHash(@NonNull BitbucketPullRequest pull) throws IOException {
        return this.resolveCommit(pull).getHash();
    }

    @Override
    @NonNull
    public BitbucketCommit resolveCommit(@NonNull BitbucketPullRequest pull) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests/{pullId}/commits{?fields,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pullId", (Object)pull.getId()).set("fields", (Object)"values.hash,values.author.raw,values.date,values.message").set("pagelen", (Object)1).expand();
        return (BitbucketCommit)this.getPagedRequest(url, BitbucketCloudPullRequestCommit.class).stream().findFirst().orElseThrow(() -> new BitbucketException("Could not determine commit for pull request " + pull.getId()));
    }

    @Override
    public void registerCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).expand();
        this.postRequest(url, JsonParser.toString(hook));
    }

    @Override
    public void updateCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks/{hook}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hook", (Object)hook.getUuid()).expand();
        this.putRequest(url, JsonParser.toString(hook));
    }

    @Override
    public void removeCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException {
        if (StringUtils.isBlank((CharSequence)hook.getUuid())) {
            throw new BitbucketException("Hook UUID required");
        }
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks/{uuid}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("uuid", (Object)hook.getUuid()).expand();
        this.deleteRequest(url);
    }

    @NonNull
    public List<BitbucketCloudWebhook> getWebHooks() throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks{?page,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pagelen", (Object)100).expand();
        return this.getPagedRequest(url, BitbucketCloudWebhook.class);
    }

    @Override
    @Deprecated
    public void postBuildStatus(@NonNull BitbucketBuildStatus status) throws IOException {
        CloudBuildStatusNotifier notifier = new CloudBuildStatusNotifier();
        notifier.sendBuildStatus(status, this.adapt(BitbucketAuthenticatedClient.class));
    }

    @Override
    public boolean isPrivate() throws IOException {
        return this.getRepository().isPrivate();
    }

    @Override
    @CheckForNull
    public BitbucketTeam getTeam() throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/workspaces{/owner}").set("owner", (Object)this.owner).expand();
        ICheckedCallable request = () -> {
            try {
                return this.getRequestAs(url, BitbucketCloudWorkspace.class);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        };
        try {
            if (this.enableCache) {
                return cachedTeam.get(this.owner, request);
            }
            return request.call();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    @Deprecated(since="935.0.0", forRemoval=true)
    @CheckForNull
    public AvatarImage getTeamAvatar() throws IOException {
        BitbucketTeam team = this.getTeam();
        return this.getAvatar(team == null ? null : team.getAvatar());
    }

    @Override
    @CheckForNull
    public AvatarImage getAvatar(@CheckForNull String url) throws IOException {
        if (url != null) {
            try {
                BufferedImage avatar = this.getImageRequest(url);
                return new AvatarImage(avatar, System.currentTimeMillis());
            }
            catch (FileNotFoundException e) {
                this.logger.log(Level.FINE, "Failed to get avatar from URL {0}", url);
            }
            catch (BitbucketRequestException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
        }
        return AvatarImage.EMPTY;
    }

    @NonNull
    public List<BitbucketCloudRepository> getRepositories(@CheckForNull UserRoleInRepository role) throws IOException {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(this.owner);
        if (this.getAuthenticator() != null) {
            cacheKey.append("::").append(this.getAuthenticator().getId());
        } else {
            cacheKey.append("::<anonymous>");
        }
        UriTemplate template = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner}{?role,page,pagelen,q}").set("owner", (Object)this.owner).set("pagelen", (Object)100);
        if (StringUtils.isNotBlank((CharSequence)this.projectKey)) {
            template.set("q", (Object)("project.key=\"" + this.projectKey + "\""));
            cacheKey.append("::").append(this.projectKey);
        } else {
            cacheKey.append("::<undefined>");
        }
        if (role != null && this.getAuthenticator() != null) {
            template.set("role", (Object)role.getId());
            cacheKey.append("::").append(role.getId());
        } else {
            cacheKey.append("::<undefined>");
        }
        String url = template.expand();
        ICheckedCallable request = () -> {
            List<BitbucketCloudRepository> repositories = this.getPagedRequest(url, BitbucketCloudRepository.class);
            repositories.sort(Comparator.comparing(BitbucketCloudRepository::getRepositoryName));
            return repositories;
        };
        if (this.enableCache) {
            try {
                return cachedRepositories.get(cacheKey.toString(), request);
            }
            catch (ExecutionException e) {
                BitbucketRequestException bre = BitbucketApiUtils.unwrap(e);
                if (bre != null) {
                    throw bre;
                }
                throw new IOException(e);
            }
        }
        return request.call();
    }

    @NonNull
    public List<BitbucketCloudRepository> getRepositories() throws IOException {
        return this.getRepositories(null);
    }

    private BufferedImage getImageRequest(String path) throws IOException {
        try (InputStream inputStream = this.getRequestAsInputStream(path);){
            int length = 16384;
            BufferedInputStream bis = new BufferedInputStream(inputStream, length);
            BufferedImage bufferedImage = ImageIO.read(bis);
            return bufferedImage;
        }
    }

    @Override
    protected HttpClientConnectionManager getConnectionManager() {
        return connectionManager;
    }

    @Override
    @NonNull
    protected HttpHost getHost() {
        return API_HOST;
    }

    @Override
    @NonNull
    protected String getBaseURL() {
        return "https://api.bitbucket.org";
    }

    @Override
    @NonNull
    protected CloseableHttpClient getClient() {
        return this.client;
    }

    @Override
    public Iterable<SCMFile> getDirectoryContent(BitbucketSCMFile parent) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)parent.getHash()).set("path", (Object)parent.getPath()).expand();
        List<BitbucketRepositorySource> sources = this.getPagedRequest(url, BitbucketRepositorySource.class);
        return sources.stream().map(source -> source.toBitbucketSCMFile(parent)).map(SCMFile.class::cast).toList();
    }

    @Override
    public InputStream getFileContent(@NonNull BitbucketSCMFile file) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path}{?at}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)file.getHash()).set("path", (Object)file.getPath()).set("at", (Object)file.getRef()).expand();
        return this.getRequestAsInputStream(url);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NonNull
    public SCMFile getFile(@NonNull BitbucketSCMFile file) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path}?format=meta").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)(file.getHash() != null ? file.getHash() : file.getRef())).set("path", (Object)file.getPath()).expand();
        BitbucketRepositorySource src = this.getRequestAs(url, BitbucketRepositorySource.class);
        return src.toBitbucketSCMFile((BitbucketSCMFile)file.parent());
    }

    @NonNull
    public List<BitbucketCloudCommit> getCommits(@CheckForNull String fromCommit, @NonNull String toCommit) throws IOException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commits{?include,exclude}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("include", (Object)toCommit).set("exclude", (Object)fromCommit).expand();
        return this.getPagedRequest(url, BitbucketCloudCommit.class);
    }

    private <V> List<V> getPagedRequest(String url, final Class<V> resultType) throws IOException {
        ArrayList resources = new ArrayList();
        String response = this.getRequest(url);
        final ParameterizedType parameterizedType = new ParameterizedType(){

            @Override
            public Type getRawType() {
                return BitbucketCloudPage.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{resultType};
            }
        };
        try {
            TypeReference type = new TypeReference<BitbucketCloudPage<V>>(){

                public Type getType() {
                    return parameterizedType;
                }
            };
            BitbucketCloudPage page = (BitbucketCloudPage)JsonParser.toJava(response, type);
            resources.addAll(page.getValues());
            while (!page.isLastPage()) {
                response = this.getRequest(page.getNext());
                page = (BitbucketCloudPage)JsonParser.toJava(response, type);
                resources.addAll(page.getValues());
            }
        }
        catch (JacksonException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
        return resources;
    }

    private <V> V getRequestAs(String url, Class<V> resultType) throws IOException {
        String response = this.getRequest(url);
        try {
            return JsonParser.toJava(response, resultType);
        }
        catch (JacksonException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    private class CommitClosure
    implements Callable<BitbucketCommit> {
        private final String hash;

        public CommitClosure(String hash) {
            this.hash = hash;
        }

        @Override
        public BitbucketCommit call() throws Exception {
            return BitbucketCloudApiClient.this.resolveCommit(this.hash);
        }
    }
}

