/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin.PluginPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerWebhookPayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RestrictedSince;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.collections4.MultiValuedMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Deprecated(since="937.0.0")
@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class PluginPushWebhookProcessor
extends AbstractWebhookProcessor {
    private static final Logger logger = Logger.getLogger(PluginPushWebhookProcessor.class.getName());
    private static final List<String> supportedEvents = List.of(HookEventType.PUSH.getKey(), HookEventType.PULL_REQUEST_UPDATED.getKey());

    @Override
    public boolean canHandle(Map<String, String> headers, MultiValuedMap<String, String> parameters) {
        return headers.containsKey("X-Event-Key") && headers.containsKey("X-Bitbucket-Type") && supportedEvents.contains(headers.get("X-Event-Key")) && parameters.containsKey((Object)"server_url");
    }

    @Override
    public void process(@NonNull String eventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        BitbucketPushEvent push = BitbucketServerWebhookPayload.pushEventFromPayload(payload);
        if (push != null) {
            if (push.getChanges().isEmpty()) {
                String owner = push.getRepository().getOwnerName();
                String repository = push.getRepository().getRepositoryName();
                if (!this.reindexOnEmptyChanges()) {
                    logger.log(Level.INFO, "Received push hook with empty changes from Bitbucket. Processing indexing on {0}/{1}. You may skip this scan by adding the system property -D{2}=false on startup.", new Object[]{owner, repository, "bitbucket.hooks.processor.scanOnEmptyChanges"});
                    this.scmSourceReIndex(owner, repository, null);
                } else {
                    logger.log(Level.INFO, "Received push hook with empty changes from Bitbucket for {0}/{1}. Skipping.", new Object[]{owner, repository});
                }
            } else {
                SCMEvent.Type type = null;
                for (BitbucketPushEvent.Change change : push.getChanges()) {
                    if ((type == null || type == SCMEvent.Type.CREATED) && change.isCreated()) {
                        type = SCMEvent.Type.CREATED;
                        continue;
                    }
                    if ((type == null || type == SCMEvent.Type.REMOVED) && change.isClosed()) {
                        type = SCMEvent.Type.REMOVED;
                        continue;
                    }
                    type = SCMEvent.Type.UPDATED;
                }
                this.notifyEvent(new PluginPushEvent(type, push, this.getOrigin(context)), BitbucketSCMSource.getEventDelaySeconds());
            }
        }
    }

    @Override
    public void verifyPayload(Map<String, String> headers, String body, BitbucketEndpoint endpoint) {
    }
}

