/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistration;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentialsUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.triggers.SafeTimerTask;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

@Extension
public class WebhookAutoRegisterListener
extends ItemListener {
    private static final Logger logger = Logger.getLogger(WebhookAutoRegisterListener.class.getName());
    private static ExecutorService executorService;

    public void onCreated(Item item) {
        if (!this.isApplicable(item)) {
            return;
        }
        this.registerHooksAsync((SCMSourceOwner)item);
    }

    public void onDeleted(Item item) {
        if (!this.isApplicable(item)) {
            return;
        }
        this.removeHooksAsync((SCMSourceOwner)item);
    }

    public void onUpdated(Item item) {
        if (!this.isApplicable(item)) {
            return;
        }
        this.registerHooksAsync((SCMSourceOwner)item);
    }

    private boolean isApplicable(Item item) {
        if (!(item instanceof SCMSourceOwner)) {
            return false;
        }
        for (SCMSource source : ((SCMSourceOwner)item).getSCMSources()) {
            if (!(source instanceof BitbucketSCMSource)) continue;
            return true;
        }
        return false;
    }

    private void registerHooksAsync(final SCMSourceOwner owner) {
        WebhookAutoRegisterListener.getExecutorService().submit((Runnable)new SafeTimerTask(){

            public void doRun() {
                try {
                    WebhookAutoRegisterListener.this.registerHooks(owner);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e, () -> "Could not register hooks for " + owner.getFullName());
                }
            }
        });
    }

    private void removeHooksAsync(final SCMSourceOwner owner) {
        WebhookAutoRegisterListener.getExecutorService().submit((Runnable)new SafeTimerTask(){

            public void doRun() {
                try {
                    WebhookAutoRegisterListener.this.removeHooks(owner);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e, () -> "Could not deregister hooks for " + owner.getFullName());
                }
            }
        });
    }

    private synchronized void registerHooks(SCMSourceOwner owner) throws IOException {
        List<BitbucketSCMSource> sources = this.getBitbucketSCMSources(owner);
        if (sources.isEmpty()) {
            return;
        }
        for (BitbucketSCMSource source : sources) {
            BitbucketEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(source.getServerUrl()).orElse(null);
            if (endpoint == null) continue;
            String rootUrl = (String)ObjectUtils.firstNonNull((Object[])new String[]{endpoint.getWebhook().getEndpointJenkinsRootURL(), BitbucketWebhookConfiguration.getDefaultJenkinsRootURL()});
            if (rootUrl.startsWith("http://localhost") || rootUrl.startsWith("http://unconfigured-jenkins-location")) {
                logger.log(Level.WARNING, "Can not register hook. Jenkins root URL is not valid: {0}", rootUrl);
                continue;
            }
            WebhookRegistration registration = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).webhookRegistration();
            if (registration == WebhookRegistration.DISABLE) {
                logger.log(Level.INFO, "Registering hook disabled by project configuration for {0}/{1}", new Object[]{source.getRepoOwner(), source.getRepository()});
                continue;
            }
            if (registration == WebhookRegistration.ITEM) {
                this.registerHook(source, endpoint);
                continue;
            }
            if (registration != WebhookRegistration.SYSTEM || !endpoint.getWebhook().isManageHooks()) continue;
            this.registerHook(source, endpoint);
        }
    }

    void registerHook(@NonNull BitbucketSCMSource source, @NonNull BitbucketEndpoint endpoint) throws IOException {
        BitbucketApi client = this.getClientBySource(source, endpoint);
        if (client == null) {
            return;
        }
        BitbucketWebhookManager manager = this.buildWebhookManager(source, endpoint);
        try (BitbucketAuthenticatedClient webhookClient = client.adapt(BitbucketAuthenticatedClient.class);){
            manager.register(webhookClient);
        }
    }

    private BitbucketWebhookManager buildWebhookManager(BitbucketSCMSource source, BitbucketEndpoint endpoint) {
        BitbucketWebhookConfiguration webhookConfig = endpoint.getWebhook();
        BitbucketWebhookManager manager = (BitbucketWebhookManager)ExtensionList.lookupFirst(webhookConfig.getManager());
        manager.apply(webhookConfig);
        String callbackRootURL = this.getCallbackRootURL(webhookConfig);
        String callbackURL = callbackRootURL + "bitbucket-scmsource-hook/notify";
        manager.setCallbackURL(callbackURL, endpoint);
        manager.withTraits(source.getTraits());
        return manager;
    }

    private String getCallbackRootURL(BitbucketWebhookConfiguration webhookConfig) {
        String callbackRootURL = webhookConfig.getEndpointJenkinsRootURL();
        if (callbackRootURL == null) {
            callbackRootURL = Util.ensureEndsWith((String)URLUtils.normalizeURL(Util.fixEmptyAndTrim((String)DisplayURLProvider.get().getRoot())), (String)"/");
        }
        return callbackRootURL;
    }

    private void removeHooks(SCMSourceOwner owner) throws IOException {
        List<BitbucketSCMSource> sources = this.getBitbucketSCMSources(owner);
        for (BitbucketSCMSource source : sources) {
            BitbucketApi client;
            BitbucketEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(source.getServerUrl()).orElse(null);
            if (endpoint == null || (client = this.getClientBySource(source, endpoint)) == null) continue;
            BitbucketAuthenticatedClient webhookClient = client.adapt(BitbucketAuthenticatedClient.class);
            try {
                if (webhookClient == null) continue;
                BitbucketWebhookManager manager = this.buildWebhookManager(source, endpoint);
                List<BitbucketWebHook> webhooks = manager.read(webhookClient).stream().filter(hook -> hook.getUrl().startsWith(this.getCallbackRootURL(endpoint.getWebhook()))).toList();
                for (BitbucketWebHook hook2 : webhooks) {
                    if (hook2 != null && !this.isUsedSomewhereElse(owner, source.getRepoOwner(), source.getRepository())) {
                        logger.log(Level.INFO, "Removing hook for {0}/{1}", new Object[]{source.getRepoOwner(), source.getRepository()});
                        manager.remove(hook2.getUuid(), webhookClient);
                        continue;
                    }
                    logger.log(Level.FINE, "NOT removing hook for {0}/{1} because does not exists or its used in other project", new Object[]{source.getRepoOwner(), source.getRepository()});
                }
            }
            finally {
                if (webhookClient == null) continue;
                webhookClient.close();
            }
        }
    }

    @CheckForNull
    private BitbucketApi getClientBySource(@NonNull BitbucketSCMSource source, @NonNull BitbucketEndpoint endpoint) {
        switch (this.getRegistration(source)) {
            case SYSTEM: {
                return BitbucketApiFactory.newInstance(endpoint.getServerURL(), this.getWebhookAuthenticator(endpoint), source.getRepoOwner(), null, source.getRepository());
            }
            case ITEM: {
                return source.buildBitbucketClient();
            }
        }
        return null;
    }

    @CheckForNull
    private BitbucketAuthenticator getWebhookAuthenticator(@NonNull BitbucketEndpoint endpoint) {
        StandardCredentials credentials = null;
        BitbucketWebhookConfiguration webhook = endpoint.getWebhook();
        String credentialsId = Util.fixEmptyAndTrim((String)webhook.getCredentialsId());
        if (credentialsId != null) {
            credentials = BitbucketCredentialsUtils.lookupCredentials(Jenkins.get(), endpoint.getServerURL(), credentialsId, StandardCredentials.class);
        }
        if (credentials != null) {
            return (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(endpoint.getServerURL()), (Credentials)credentials);
        }
        return null;
    }

    private WebhookRegistration getRegistration(@NonNull BitbucketSCMSource source) {
        return ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).webhookRegistration();
    }

    private boolean isUsedSomewhereElse(SCMSourceOwner owner, String repoOwner, String repoName) {
        Iterable all = SCMSourceOwners.all();
        for (SCMSourceOwner other : all) {
            if (owner == other) continue;
            for (SCMSource otherSource : other.getSCMSources()) {
                BitbucketSCMSource bbSCMSource;
                if (!(otherSource instanceof BitbucketSCMSource) || !StringUtils.equalsIgnoreCase((CharSequence)(bbSCMSource = (BitbucketSCMSource)otherSource).getRepoOwner(), (CharSequence)repoOwner) || !bbSCMSource.getRepository().equals(repoName)) continue;
                return true;
            }
        }
        return false;
    }

    private List<BitbucketSCMSource> getBitbucketSCMSources(SCMSourceOwner owner) {
        return owner.getSCMSources().stream().filter(BitbucketSCMSource.class::isInstance).map(BitbucketSCMSource.class::cast).toList();
    }

    private static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), WebhookAutoRegisterListener.class.getName()));
        }
        return executorService;
    }
}

