/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.webhook;

import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Describable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface BitbucketWebhookConfiguration
extends Describable<BitbucketWebhookConfiguration> {
    @CheckForNull
    public String getDisplayName();

    @NonNull
    public String getId();

    public boolean isManageHooks();

    @CheckForNull
    public String getCredentialsId();

    @CheckForNull
    public String getEndpointJenkinsRootURL();

    @NonNull
    public static String getDefaultJenkinsRootURL() {
        String jenkinsURL = URLUtils.normalizeURL(Util.fixEmptyAndTrim((String)DisplayURLProvider.get().getRoot()));
        return Util.ensureEndsWith((String)jenkinsURL, (String)"/");
    }

    public Class<? extends BitbucketWebhookManager> getManager();

    default public BitbucketWebhookDescriptor getDescriptor() {
        return (BitbucketWebhookDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }
}

