/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook;

import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.Messages;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractBitbucketWebhookConfiguration
implements BitbucketWebhookConfiguration {
    private boolean manageHooks;
    @CheckForNull
    private String credentialsId;
    private final boolean enableHookSignature;
    @CheckForNull
    private final String hookSignatureCredentialsId;
    private String endpointJenkinsRootURL;

    protected AbstractBitbucketWebhookConfiguration(boolean manageHooks, @CheckForNull String credentialsId, boolean enableHookSignature, @CheckForNull String hookSignatureCredentialsId) {
        this.manageHooks = manageHooks && StringUtils.isNotBlank((CharSequence)credentialsId);
        this.credentialsId = manageHooks ? Util.fixEmptyAndTrim((String)credentialsId) : null;
        this.enableHookSignature = enableHookSignature && StringUtils.isNotBlank((CharSequence)hookSignatureCredentialsId);
        this.hookSignatureCredentialsId = enableHookSignature ? Util.fixEmptyAndTrim((String)hookSignatureCredentialsId) : null;
    }

    @Override
    public final boolean isManageHooks() {
        return this.manageHooks;
    }

    @Override
    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public String getHookSignatureCredentialsId() {
        return this.hookSignatureCredentialsId;
    }

    public boolean isEnableHookSignature() {
        return this.enableHookSignature;
    }

    @Override
    @CheckForNull
    public String getEndpointJenkinsRootURL() {
        return this.endpointJenkinsRootURL;
    }

    @DataBoundSetter
    public void setEndpointJenkinsRootURL(@CheckForNull String endpointJenkinsRootURL) {
        String url = Util.fixEmptyAndTrim((String)endpointJenkinsRootURL);
        if (url != null) {
            this.endpointJenkinsRootURL = Util.ensureEndsWith((String)URLUtils.normalizeURL(url), (String)"/");
        }
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return Messages.ServerWebhookImplementation_displayName();
    }

    public static abstract class AbstractBitbucketWebhookDescriptorImpl
    extends BitbucketWebhookDescriptor {
        @RequirePOST
        public static FormValidation doCheckEndpointJenkinsRootURL(@QueryParameter String value) {
            AbstractBitbucketWebhookDescriptorImpl.checkPermission();
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }

        protected ListBoxModel getHookSignatureCredentialsIdItems(String hookSignatureCredentialsId, String serverURL) {
            Jenkins jenkins = AbstractBitbucketWebhookDescriptorImpl.checkPermission();
            StandardListBoxModel result = new StandardListBoxModel();
            result.includeMatchingAs(ACL.SYSTEM2, (ItemGroup)jenkins, StringCredentials.class, URIRequirementBuilder.fromUri((String)serverURL).build(), CredentialsMatchers.always());
            if (hookSignatureCredentialsId != null) {
                result.includeCurrentValue(hookSignatureCredentialsId);
            }
            return result;
        }

        protected static Jenkins checkPermission() {
            Jenkins jenkins = Jenkins.get();
            jenkins.checkPermission(Jenkins.MANAGE);
            return jenkins;
        }
    }
}

