/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.extension;

import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.util.Map;
import java.util.Objects;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketEnvVarExtension
extends GitSCMExtension {
    private final String owner;
    private final String repository;
    private final String projectKey;
    private final String serverURL;

    @DataBoundConstructor
    public BitbucketEnvVarExtension(@Nullable String owner, @NonNull String repository, @Nullable String projectKey, @NonNull String serverURL) {
        this.owner = owner;
        this.repository = repository;
        this.projectKey = projectKey;
        this.serverURL = URLUtils.removeAuthority(serverURL);
    }

    public void populateEnvironmentVariables(GitSCM scm, Map<String, String> env) {
        env.put("BITBUCKET_REPOSITORY", this.getRepository());
        env.put("BITBUCKET_OWNER", this.getOwner());
        env.put("BITBUCKET_PROJECT_KEY", this.getProjectKey());
        env.put("BITBUCKET_SERVER_URL", this.getServerURL());
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.projectKey, this.repository, this.serverURL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BitbucketEnvVarExtension other = (BitbucketEnvVarExtension)((Object)obj);
        return Objects.equals(this.owner, other.owner) && Objects.equals(this.projectKey, other.projectKey) && Objects.equals(this.repository, other.repository) && Objects.equals(this.serverURL, other.serverURL);
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Contribute additional environment variables about the target branch.";
        }
    }
}

