/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.casc;

import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudWebhookConfiguration;
import hudson.Extension;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.configurators.DataBoundConfigurator;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class BitbucketCloudEndpointConfigurator
extends DataBoundConfigurator<BitbucketCloudEndpoint> {
    private static final Logger logger = Logger.getLogger(BitbucketCloudEndpointConfigurator.class.getName());

    public BitbucketCloudEndpointConfigurator() {
        super(BitbucketCloudEndpoint.class);
    }

    protected BitbucketCloudEndpoint instance(Mapping mapping, ConfigurationContext context) throws ConfiguratorException {
        boolean enableCache = false;
        if (mapping.containsKey((Object)"enableCache")) {
            enableCache = Boolean.parseBoolean(mapping.getScalarValue("enableCache"));
        }
        int teamCacheDuration = 0;
        if (mapping.containsKey((Object)"teamCacheDuration")) {
            teamCacheDuration = Integer.parseInt(mapping.getScalarValue("teamCacheDuration"));
        }
        int repositoriesCacheDuration = 0;
        if (mapping.containsKey((Object)"repositoriesCacheDuration")) {
            repositoriesCacheDuration = Integer.parseInt(mapping.getScalarValue("repositoriesCacheDuration"));
        }
        BitbucketWebhookConfiguration webhook = this.getWebhook(mapping);
        return new BitbucketCloudEndpoint(enableCache, teamCacheDuration, repositoriesCacheDuration, webhook);
    }

    private BitbucketWebhookConfiguration getWebhook(Mapping mapping) {
        boolean manageHooks = false;
        if (mapping.containsKey((Object)"manageHooks")) {
            logger.warning("manageHooks is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            manageHooks = Boolean.parseBoolean(StringUtils.trimToNull((String)mapping.getScalarValue("manageHooks")));
        }
        String credentialsId = null;
        if (mapping.containsKey((Object)"credentialsId")) {
            logger.warning("credentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            credentialsId = mapping.getScalarValue("credentialsId");
        }
        boolean enableHookSignature = false;
        if (mapping.containsKey((Object)"enableHookSignature")) {
            logger.warning("enableHookSignature is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            enableHookSignature = Boolean.parseBoolean(StringUtils.trimToNull((String)mapping.getScalarValue("enableHookSignature")));
        }
        String hookSignatureCredentialsId = null;
        if (mapping.containsKey((Object)"hookSignatureCredentialsId")) {
            logger.warning("hookSignatureCredentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            hookSignatureCredentialsId = mapping.getScalarValue("hookSignatureCredentialsId");
        }
        return new CloudWebhookConfiguration(manageHooks, credentialsId, enableHookSignature, hookSignatureCredentialsId);
    }
}

