/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.trait;

import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.trait.BitbucketSCMSourceTraitDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.sql.Date;
import java.time.LocalDate;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DiscardOldTagTrait
extends SCMSourceTrait {
    private int keepForDays;

    @DataBoundConstructor
    public DiscardOldTagTrait(@CheckForNull int keepForDays) {
        this.keepForDays = keepForDays;
    }

    public int getKeepForDays() {
        return this.keepForDays;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        if (this.keepForDays > 0) {
            context.withPrefilter((SCMHeadPrefilter)new ExcludeOldSCMTag(this.keepForDays));
        }
    }

    public static final class ExcludeOldSCMTag
    extends SCMHeadPrefilter {
        private final int keepForDays;

        public ExcludeOldSCMTag(int keepForDays) {
            this.keepForDays = keepForDays;
        }

        public boolean isExcluded(@NonNull SCMSource source, @NonNull SCMHead head) {
            TagSCMHead tagHead;
            if (!(head instanceof TagSCMHead) || (tagHead = (TagSCMHead)head).getTimestamp() == 0L) {
                return false;
            }
            LocalDate commitDate = this.asLocalDate(tagHead.getTimestamp());
            LocalDate expiryDate = LocalDate.now().minusDays(this.keepForDays);
            return commitDate.isBefore(expiryDate);
        }

        @NonNull
        private LocalDate asLocalDate(@NonNull long milliseconds) {
            return new Date(milliseconds).toLocalDate();
        }
    }

    @Symbol(value={"bitbucketDiscardOldTag"})
    @Extension
    public static class DescriptorImpl
    extends BitbucketSCMSourceTraitDescriptor {
        public FormValidation doCheckKeepForDays(@QueryParameter int keepForDays) {
            if (keepForDays <= 0) {
                return FormValidation.error((String)Messages.DiscardOldTagTrait_invalidDays());
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.DiscardOldTagTrait_displayName();
        }
    }
}

