/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;

public final class SCMUtils {
    private SCMUtils() {
    }

    @CheckForNull
    public static String getHash(@Nullable SCMRevision revision) {
        if (revision == null) {
            return null;
        }
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            AbstractGitSCMSource.SCMRevisionImpl gitRev = (AbstractGitSCMSource.SCMRevisionImpl)revision;
            return gitRev.getHash();
        }
        if (revision instanceof ChangeRequestSCMRevision) {
            ChangeRequestSCMRevision prRev = (ChangeRequestSCMRevision)revision;
            return SCMUtils.getHash(prRev.getTarget());
        }
        throw new UnsupportedOperationException("Revision of type " + revision.getClass().getSimpleName() + " is not supported.\nPlease fill an issue at https://issues.jenkins.io to the bitbucket-branch-source-plugin component.");
    }
}

