/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.casc;

import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin.PluginWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerWebhookConfiguration;
import hudson.Extension;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.configurators.DataBoundConfigurator;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class BitbucketServerEndpointConfigurator
extends DataBoundConfigurator<BitbucketServerEndpoint> {
    private static final Logger logger = Logger.getLogger(BitbucketServerEndpointConfigurator.class.getName());

    public BitbucketServerEndpointConfigurator() {
        super(BitbucketServerEndpoint.class);
    }

    protected BitbucketServerEndpoint instance(Mapping mapping, ConfigurationContext context) throws ConfiguratorException {
        String displayName = mapping.getScalarValue("displayName");
        String serverURL = mapping.containsKey((Object)"serverUrl") ? mapping.getScalarValue("serverUrl") : mapping.getScalarValue("serverURL");
        String serverVersion = null;
        if (mapping.containsKey((Object)"serverVersion")) {
            serverVersion = mapping.getScalarValue("serverVersion");
        }
        BitbucketWebhookConfiguration webhook = this.getWebhook(mapping);
        BitbucketServerEndpoint endpoint = new BitbucketServerEndpoint(displayName, serverURL, webhook);
        if (serverVersion != null) {
            endpoint.setServerVersion(serverVersion);
        }
        if (mapping.containsKey((Object)"callCanMerge")) {
            logger.warning("callCanMerge is deprecated and ignored for BitbucketServerEndpoint definition, remove from your CasC definition.");
            mapping.remove((Object)"callCanMerge");
        }
        if (mapping.containsKey((Object)"callChanges")) {
            logger.warning("callChanges is deprecated and ignored for BitbucketServerEndpoint definition, remove from your CasC definition.");
            mapping.remove((Object)"callChanges");
        }
        return endpoint;
    }

    private BitbucketWebhookConfiguration getWebhook(Mapping mapping) {
        boolean manageHooks = false;
        if (mapping.containsKey((Object)"manageHooks")) {
            logger.warning("manageHooks is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            manageHooks = Boolean.parseBoolean(StringUtils.trimToNull((String)mapping.getScalarValue("manageHooks")));
        }
        String credentialsId = null;
        if (mapping.containsKey((Object)"credentialsId")) {
            logger.warning("credentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            credentialsId = mapping.getScalarValue("credentialsId");
        }
        boolean enableHookSignature = false;
        if (mapping.containsKey((Object)"enableHookSignature")) {
            logger.warning("enableHookSignature is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            enableHookSignature = Boolean.parseBoolean(StringUtils.trimToNull((String)mapping.getScalarValue("enableHookSignature")));
        }
        String hookSignatureCredentialsId = null;
        if (mapping.containsKey((Object)"hookSignatureCredentialsId")) {
            logger.warning("hookSignatureCredentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            hookSignatureCredentialsId = mapping.getScalarValue("hookSignatureCredentialsId");
        }
        String webhookImplementation = null;
        if (mapping.containsKey((Object)"webhookImplementation")) {
            logger.warning("webhookImplementation is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            webhookImplementation = mapping.getScalarValue("webhookImplementation");
        }
        BitbucketWebhookConfiguration webhook = "NATIVE".equals(webhookImplementation) ? new ServerWebhookConfiguration(manageHooks, credentialsId, enableHookSignature, hookSignatureCredentialsId) : new PluginWebhookConfiguration(manageHooks, credentialsId);
        return webhook;
    }
}

