/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessorException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class BitbucketSCMSourcePushHookReceiver
extends CrumbExclusion
implements UnprotectedRootAction {
    private static final Logger logger = Logger.getLogger(BitbucketSCMSourcePushHookReceiver.class.getName());
    private static final String PATH = "bitbucket-scmsource-hook";
    public static final String FULL_PATH = "bitbucket-scmsource-hook/notify";

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/bitbucket-scmsource-hook/notify")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }

    public String getUrlName() {
        return PATH;
    }

    public HttpResponse doNotify(StaplerRequest2 req) throws IOException {
        try {
            Map<String, String> reqHeaders = this.getHeaders(req);
            MultiValuedMap<String, String> reqParameters = this.getParameters(req);
            BitbucketWebhookProcessor hookProcessor = this.getHookProcessor(reqHeaders, reqParameters);
            String body = IOUtils.toString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)body)) {
                return HttpResponses.error((int)400, (String)"Payload is empty.");
            }
            String serverURL = hookProcessor.getServerURL(Collections.unmodifiableMap(reqHeaders), (MultiValuedMap<String, String>)MultiMapUtils.unmodifiableMultiValuedMap(reqParameters));
            BitbucketEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(null);
            if (endpoint == null) {
                logger.log(Level.SEVERE, "No configured bitbucket endpoint found for {0}.", serverURL);
                return HttpResponses.error((int)400, (String)("No bitbucket endpoint found for " + serverURL));
            }
            logger.log(Level.FINE, "Payload endpoint host {0}, request endpoint host {1}", new Object[]{endpoint, req.getRemoteAddr()});
            hookProcessor.verifyPayload(reqHeaders, body, endpoint);
            Map<String, Object> context = hookProcessor.buildHookContext((HttpServletRequest)req);
            String eventType = hookProcessor.getEventType(Collections.unmodifiableMap(reqHeaders), (MultiValuedMap<String, String>)MultiMapUtils.unmodifiableMultiValuedMap(reqParameters));
            hookProcessor.process(eventType, body, context, endpoint);
        }
        catch (BitbucketWebhookProcessorException e) {
            return HttpResponses.error((int)e.getHttpCode(), (String)e.getMessage());
        }
        return HttpResponses.ok();
    }

    private BitbucketWebhookProcessor getHookProcessor(Map<String, String> reqHeaders, MultiValuedMap<String, String> reqParameters) {
        List<BitbucketWebhookProcessor> matchingProcessors = this.getHookProcessors().filter(processor -> processor.canHandle(Collections.unmodifiableMap(reqHeaders), (MultiValuedMap<String, String>)MultiMapUtils.unmodifiableMultiValuedMap((MultiValuedMap)reqParameters))).toList();
        if (matchingProcessors.isEmpty()) {
            logger.warning(() -> "No processor found for the incoming Bitbucket hook. Skipping.");
            throw new BitbucketWebhookProcessorException(400, "No processor found that supports this event. Refer to the user documentation on how configure the webHook in Bitbucket at https://github.com/jenkinsci/bitbucket-branch-source-plugin/blob/master/docs/USER_GUIDE.adoc#webhooks-registering");
        }
        if (matchingProcessors.size() > 1) {
            String processors = StringUtils.joinWith((String)"\n- ", (Object[])new Object[]{matchingProcessors.stream().map(p -> p.getClass().getName()).toList()});
            logger.severe(() -> "More processors found that handle the incoming Bitbucket hook:\n" + processors);
            throw new BitbucketWebhookProcessorException(409, "More processors found that handle the incoming Bitbucket hook.");
        }
        BitbucketWebhookProcessor hookProcessor = matchingProcessors.get(0);
        logger.fine(() -> "Hook processor " + hookProcessor.getClass().getName() + " found.");
        return hookProcessor;
    }

    Stream<BitbucketWebhookProcessor> getHookProcessors() {
        return ExtensionList.lookup(BitbucketWebhookProcessor.class).stream();
    }

    private MultiValuedMap<String, String> getParameters(StaplerRequest2 req) {
        ArrayListValuedHashMap reqParameters = new ArrayListValuedHashMap();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            reqParameters.putAll((Object)((String)entry.getKey()), Arrays.asList((String[])entry.getValue()));
        }
        return reqParameters;
    }

    private Map<String, String> getHeaders(StaplerRequest2 req) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        for (String headerName : EnumerationUtils.asIterable((Enumeration)req.getHeaderNames())) {
            reqHeaders.put(headerName, req.getHeader(headerName));
        }
        return reqHeaders;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }
}

