/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client.events;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudBranch;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketCloudPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketCloudPullRequestDestination;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketCloudPullRequestRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepositoryOwner;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

public class BitbucketCloudPullRequestEvent
implements BitbucketPullRequestEvent {
    @JsonProperty(value="pullrequest")
    private BitbucketCloudPullRequest pullRequest;
    private BitbucketCloudRepository repository;

    @Override
    public BitbucketPullRequest getPullRequest() {
        return this.pullRequest;
    }

    public void setPullRequest(BitbucketCloudPullRequest pullRequest) {
        this.pullRequest = pullRequest;
        this.reconstructMissingData();
    }

    @Override
    public BitbucketRepository getRepository() {
        return this.repository;
    }

    public void setRepository(BitbucketCloudRepository repository) {
        this.repository = repository;
        this.reconstructMissingData();
    }

    private void reconstructMissingData() {
        if (this.repository != null && this.pullRequest != null) {
            BitbucketCloudPullRequestDestination destination;
            BitbucketCloudRepository sourceRepository;
            BitbucketCloudPullRequestRepository source = this.pullRequest.getSource();
            if (source != null && (sourceRepository = source.getRepository()) != null) {
                if (sourceRepository.getScm() == null) {
                    sourceRepository.setScm(this.repository.getScm());
                }
                if (sourceRepository.getOwner() == null) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)sourceRepository.getOwnerName(), (CharSequence)this.repository.getOwnerName())) {
                        BitbucketCloudRepositoryOwner owner = new BitbucketCloudRepositoryOwner();
                        owner.setUsername(sourceRepository.getOwnerName());
                        owner.setDisplayName(this.pullRequest.getAuthorLogin());
                        if (this.repository.isPrivate()) {
                            sourceRepository.setPrivate(this.repository.isPrivate());
                        }
                        sourceRepository.setOwner(owner);
                    } else {
                        sourceRepository.setOwner(this.repository.getOwner());
                        sourceRepository.setPrivate(this.repository.isPrivate());
                    }
                }
            }
            if (source != null) {
                BitbucketCloudBranch sourceBranch = source.getBranch();
                BitbucketCommit sourceCommit = source.getCommit();
                if (sourceCommit != null && sourceBranch != null) {
                    if (sourceBranch.getRawNode() == null) {
                        sourceBranch.setRawNode(sourceCommit.getHash());
                    }
                    if (sourceBranch.getDateMillis() == 0L && sourceCommit.getCommitterDate() != null) {
                        sourceBranch.setDateMillis(sourceCommit.getCommitterDate().getTime());
                    }
                }
            }
            if ((destination = this.pullRequest.getDestination()) != null && destination.getRepository() != null) {
                if (destination.getRepository().getScm() == null) {
                    destination.getRepository().setScm(this.repository.getScm());
                }
                if (destination.getRepository().getOwner() == null && StringUtils.equalsIgnoreCase((CharSequence)destination.getRepository().getOwnerName(), (CharSequence)this.repository.getOwnerName())) {
                    destination.getRepository().setOwner(this.repository.getOwner());
                    destination.getRepository().setPrivate(this.repository.isPrivate());
                }
            }
            if (destination != null && destination.getCommit() != null && destination.getBranch() != null && destination.getBranch().getRawNode() == null) {
                destination.getBranch().setRawNode(destination.getCommit().getHash());
            }
        }
    }
}

