/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.utility;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLoader {
    private static final Logger log = LoggerFactory.getLogger(PropertyLoader.class);
    private Properties props = null;
    private Properties envVariables = new Properties();
    private static final String MAIN_PROPERTIES_FILE = "config.properties";
    private static final String OVERRIDE_FILE = "config-secrets.properties";

    public void loadProperties() {
        Properties result = this.getProps(MAIN_PROPERTIES_FILE);
        Optional.ofNullable(this.getProps(OVERRIDE_FILE)).ifPresent(result::putAll);
        this.props = result;
    }

    public String getFileUrlInClassloader(String filename) throws FileNotFoundException {
        ClassLoader classLoader = PropertyLoader.class.getClassLoader();
        URL resource = classLoader.getResource(filename);
        if (resource == null) {
            log.warn("File is not found in resources: {}", (Object)filename);
            throw new FileNotFoundException();
        }
        return resource.getFile();
    }

    private Properties getProps(String filename) {
        Properties properties = new Properties();
        ClassLoader classLoader = PropertyLoader.class.getClassLoader();
        URL resource = classLoader.getResource(filename);
        if (resource == null) {
            log.warn("Test property file is not found in resources: {}", (Object)filename);
        } else {
            try (FileReader fr = new FileReader(resource.getFile());){
                properties.load(fr);
            }
            catch (IOException e) {
                log.warn("Error reading resource: {}", (Object)filename);
            }
        }
        return properties;
    }

    public String getProperty(String property) {
        if (this.props == null) {
            this.loadProperties();
        }
        String envPropertyName = this.toEnvVariable(property);
        String envPropertyValue = System.getenv(envPropertyName);
        log.info(envPropertyName + " : " + envPropertyValue);
        return StringUtils.isNotEmpty((CharSequence)envPropertyValue) ? envPropertyValue : this.props.getProperty(property);
    }

    public Properties loadEnvVariables() {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> envVar : env.entrySet()) {
            String value = envVar.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            String parsedPropertyName = this.toConfigPath(envVar.getKey());
            this.envVariables.put(parsedPropertyName, value);
            log.info(envVar + " : " + value);
        }
        return this.envVariables;
    }

    private String toConfigPath(String variableName) {
        return variableName.toLowerCase().replace("_", ".").trim();
    }

    private String toEnvVariable(String variableName) {
        return variableName.toUpperCase().replaceAll("\\.{1}", "_").trim();
    }
}

