/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.dto.ResourceType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.Parsable;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.naming.ConfigurationException;

public class PropertiesReader
extends Parsable
implements ConfigReader {
    protected ResourceType resourceType = ResourceType.PROPERTIES;
    Properties properties = new Properties();

    public void addPropertyPathValue(String pathName, String value) {
        this.properties.put(pathName, value);
    }

    public void addPropertyValue(String propertyName, String path, String value) {
        this.properties.put(path + "." + propertyName, value);
    }

    public void loadProperties(Properties properties) {
        properties.putAll((Map<?, ?>)properties);
    }

    public void loadProperties(String filepath) throws IOException {
        File file = new File(filepath);
        if (!file.exists()) {
            throw new FileNotFoundException(filepath);
        }
        try (FileInputStream is = new FileInputStream(file);){
            Properties prop = new Properties();
            prop.load(is);
            this.properties.putAll((Map<?, ?>)this.properties);
        }
    }

    @Override
    Config toConfig() throws ConfigurationException {
        return ConfigFactory.parseProperties((Properties)this.properties);
    }

    @Override
    public String getName() {
        return this.resourceType.name();
    }
}

