/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.GeneralGitDownloader;
import com.checkmarx.configprovider.dto.GeneralRepoDto;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.FileReader;
import com.checkmarx.configprovider.readers.ListReaders;
import com.checkmarx.configprovider.readers.Parsable;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.naming.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public class GeneralGitReader
extends Parsable
implements ConfigReader {
    private String cxConfigDefault = "cx.config";
    private String defaultFolder = ".checkmarx";
    private final GeneralGitDownloader downloader = new GeneralGitDownloader();
    private GeneralRepoDto repoDto;
    private FileReader fileReader;
    private ListReaders downloadedResource;

    public GeneralGitReader(GeneralRepoDto repoDto, String folder, String configFileName) throws ConfigurationException {
        Optional.ofNullable(configFileName).filter(StringUtils::isNotBlank).ifPresent(cxConfig -> {
            this.cxConfigDefault = cxConfig;
        });
        Optional.ofNullable(folder).filter(StringUtils::isNotBlank).ifPresent(cxFolder -> {
            this.cxConfigDefault = cxFolder;
        });
        this.repoDto = repoDto;
    }

    public GeneralGitReader(GeneralRepoDto repoDto) throws ConfigurationException {
        this.repoDto = repoDto;
    }

    public void close() {
        this.downloader.closeAndDelete();
    }

    @Override
    public String getName() {
        return this.downloadedResource.getName();
    }

    @Override
    Config toConfig() throws ConfigurationException {
        List<Parsable> listRawConfigYmls = this.downloader.downloadRepoFiles(this.repoDto, Arrays.asList(this.defaultFolder), this.cxConfigDefault);
        ListReaders listReaders = new ListReaders();
        for (Parsable reader : listRawConfigYmls) {
            listReaders.add((ConfigReader)((Object)reader));
        }
        this.downloadedResource = listReaders;
        return listReaders.toConfig();
    }
}

