/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.dto.ResourceType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.AbstractFileReader;
import com.typesafe.config.Config;
import java.util.Optional;
import javax.naming.ConfigurationException;

public class FileContentReader
extends AbstractFileReader
implements ConfigReader {
    private String content;
    private String name;

    @Deprecated
    public FileContentReader(ResourceType type, String fileContent, String name) {
        this(fileContent, name, type);
    }

    public FileContentReader(String fileContent, String name) {
        this(fileContent, name, ResourceType.getTypeByNameOrExtention(name));
    }

    public FileContentReader(String fileContent, String name, ResourceType type) {
        this.type = type;
        this.content = fileContent;
        this.name = name;
    }

    @Override
    public Config toConfig() throws ConfigurationException {
        if (ResourceType.YAML.equals((Object)this.type)) {
            this.config = this.yamlToConfig(this.content, "");
        } else if (ResourceType.JSON.equals((Object)this.type)) {
            this.config = this.jsonToConfig(this.content);
        }
        return this.config;
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.name).orElse(this.type.name());
    }

    public String getContent() {
        return this.content;
    }
}

