/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.dto.ResourceType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.PropertiesReader;
import com.checkmarx.configprovider.utility.PropertyLoader;

public class EnvPropertiesReader
extends PropertiesReader
implements ConfigReader {
    public EnvPropertiesReader(boolean loadEnvVariables) {
        this.resourceType = ResourceType.ENV_VARIABLES;
        if (loadEnvVariables) {
            this.properties = new PropertyLoader().loadEnvVariables();
        }
    }

    public void addEnvVariable(String propertyName, String path) {
        String propertyValue = System.getenv(propertyName);
        this.addPropertyValue(propertyName, path, propertyValue);
    }

    public void addSystemProperty(String propertyName, String path) {
        String propertyValue = System.getProperty(propertyName);
        this.addPropertyValue(propertyName, path, propertyValue);
    }
}

