/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.dto.ResourceType;
import com.checkmarx.configprovider.readers.Parsable;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.naming.ConfigurationException;
import org.apache.commons.io.IOUtils;

public abstract class AbstractFileReader
extends Parsable {
    protected ResourceType type;
    protected Config config;

    protected AbstractFileReader() {
    }

    protected static boolean isYml(String name) {
        return ResourceType.YAML == ResourceType.getTypeByNameOrExtention(name);
    }

    Config jsonToConfig(String fileContent) {
        return ConfigFactory.parseString((String)fileContent);
    }

    Config yamlToConfig(String yamlContent, String path) throws ConfigurationException {
        try {
            ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object obj = yamlReader.readValue(yamlContent, Object.class);
            ObjectMapper jsonWriter = new ObjectMapper();
            String jsonAsStr = jsonWriter.writeValueAsString(obj).replaceAll("(?<!\\\\)\"{1}", " ").replace("\\\\\\\"", "\"");
            return ConfigFactory.parseString((String)jsonAsStr);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException("Unable to parse YAML configuration file " + path);
        }
    }

    Config jsonToConfig(URL file) {
        return ConfigFactory.parseURL((URL)file);
    }

    Config yamlToConfig(URL url) {
        throw new UnsupportedOperationException();
    }

    Config yamlToConfig(File file) throws ConfigurationException {
        try {
            String yamlContent = IOUtils.toString((InputStream)new FileInputStream(file.getPath()), (Charset)StandardCharsets.UTF_8);
            return this.yamlToConfig(yamlContent, file.getPath());
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to read URL " + file.getPath());
        }
    }

    Config jsonToConfig(File file) throws ConfigurationException {
        try {
            String jsonContent = IOUtils.toString((InputStream)new FileInputStream(file.getPath()), (Charset)StandardCharsets.UTF_8);
            return this.jsonToConfig(jsonContent);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to read URL " + file.getPath());
        }
    }

    public ResourceType getType() {
        return this.type;
    }

    public Config getConfig() {
        return this.config;
    }
}

