/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.dto;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResourceType {
    YAML("yaml", "yml", "configuration"),
    JSON("json", "config"),
    PROPERTIES("properties"),
    ENV_VARIABLES("env"),
    COMBINED(new String[0]);

    private static final Logger log;
    private List<String> fileExtentions;

    private ResourceType(String ... fileExtentions) {
        this.fileExtentions = Arrays.asList(fileExtentions);
    }

    public static ResourceType getTypeByNameOrExtention(String nameOrExtention) {
        String extention = nameOrExtention.substring(nameOrExtention.lastIndexOf(46) + 1);
        log.info("resolving extention for {}", (Object)nameOrExtention);
        return Arrays.stream(ResourceType.values()).filter(type -> type.fileExtentions.contains(extention.toLowerCase().trim())).findAny().map(res -> {
            log.info("extention {} is {}", (Object)extention, (Object)res);
            return res;
        }).orElseGet(() -> {
            log.info("extention {} is {}", (Object)extention, (Object)COMBINED);
            return COMBINED;
        });
    }

    static {
        log = LoggerFactory.getLogger(ResourceType.class);
    }
}

