/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider;

import com.checkmarx.configprovider.GitHubClient;
import com.checkmarx.configprovider.dto.RepoDto;
import com.checkmarx.configprovider.dto.SourceProviderType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.exceptions.ConfigProviderException;
import com.checkmarx.configprovider.interfaces.SourceControlClient;
import com.checkmarx.configprovider.readers.FileContentReader;
import com.checkmarx.configprovider.readers.Parsable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRepoDownloader {
    private static final Logger log = LoggerFactory.getLogger(RemoteRepoDownloader.class);
    private static final EnumMap<SourceProviderType, Class<? extends SourceControlClient>> sourceProviderMapping = new EnumMap(SourceProviderType.class);
    private RepoDto repoDto;

    public Parsable loadFileByName(SourceControlClient client, RepoDto repo, String folder, String fileToFind, List<String> filenames) {
        return Optional.ofNullable(fileToFind).filter(filenames::contains).map(foundFile -> this.downloadFiles(client, repo, folder, Collections.singletonList(foundFile)).get(0)).orElse(null);
    }

    public List<Parsable> loadFileBySuffix(SourceControlClient client, RepoDto repo, String folder, String suffix, List<String> folderFiles) {
        List matchingFiles = Optional.ofNullable(suffix).map(thesuffix -> folderFiles.stream().filter(name -> name.endsWith((String)thesuffix)).collect(Collectors.toList())).orElse(new LinkedList());
        return matchingFiles.isEmpty() ? new LinkedList<Parsable>() : this.downloadFiles(client, repo, folder, matchingFiles);
    }

    public List<Parsable> downloadRepoFiles(RepoDto repo, List<String> folders, String nameToFind, String suffixToFind) throws ConfigurationException {
        log.info("Searching for a config-as-code file in a remote repo");
        RemoteRepoDownloader.validate(repo);
        this.repoDto = repo;
        List<Parsable> resources = new LinkedList<Parsable>();
        SourceControlClient client = this.determineSourceControlClient();
        for (String folder : folders) {
            List<String> filenames;
            Parsable specificFile = this.loadFileByName(client, repo, folder, nameToFind, filenames = client.getDirectoryFilenames(repo, folder));
            resources = Optional.ofNullable(specificFile).map(xva$0 -> Arrays.asList(xva$0)).orElse(this.loadFileBySuffix(client, repo, folder, suffixToFind, filenames));
            if (!resources.isEmpty() || filenames == null || filenames.isEmpty()) continue;
            resources = this.downloadFiles(client, repo, folder, filenames);
        }
        List resourceNames = resources.stream().map(resource -> ((ConfigReader)((Object)resource)).getName().concat(" ")).collect(Collectors.toList());
        if (!resourceNames.isEmpty()) {
            log.info("Config files " + resourceNames + "\nwere found for repo: " + repo.getRepoName() + " in folders: " + folders);
        }
        return resources;
    }

    private SourceControlClient determineSourceControlClient() {
        SourceProviderType providerType = this.repoDto.getSourceProviderType();
        log.debug("Determining the client for the {} source control provider", (Object)providerType);
        Class<? extends SourceControlClient> clientClass = RemoteRepoDownloader.getClientClass(providerType);
        SourceControlClient result = RemoteRepoDownloader.getClientInstance(clientClass);
        log.debug("Using {} to access the repo", (Object)result.getClass().getName());
        return result;
    }

    private static SourceControlClient getClientInstance(Class<? extends SourceControlClient> clientClass) {
        SourceControlClient result;
        try {
            result = clientClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String message = String.format("Unable to create an instance of %s.", SourceProviderType.class.getSimpleName());
            throw new ConfigProviderException(message, e);
        }
        return result;
    }

    private static Class<? extends SourceControlClient> getClientClass(SourceProviderType sourceProviderType) {
        Class<? extends SourceControlClient> clientClass = sourceProviderMapping.get((Object)sourceProviderType);
        if (clientClass == null) {
            String message = String.format("The '%s' %s is not supported", new Object[]{sourceProviderType, SourceProviderType.class.getSimpleName()});
            throw new ConfigProviderException(message);
        }
        return clientClass;
    }

    private List<Parsable> downloadFiles(SourceControlClient client, RepoDto repo, String folder, List<String> filenames) {
        LinkedList<Parsable> resources = new LinkedList<Parsable>();
        if (filenames == null || filenames.isEmpty()) {
            throw new IllegalArgumentException("file names can not be empty");
        }
        filenames.stream().sorted().forEachOrdered(filename -> {
            String fileContent = client.downloadFileContent(folder, (String)filename, repo);
            log.info("Config-as-code was found with content length: {}", (Object)fileContent.length());
            FileContentReader configResourceImpl = new FileContentReader(fileContent, (String)filename);
            resources.add(configResourceImpl);
        });
        return resources;
    }

    private static void validate(RepoDto configLocation) {
        Objects.requireNonNull(configLocation, "Repository must not be null.");
    }

    static {
        sourceProviderMapping.put(SourceProviderType.GITHUB, GitHubClient.class);
    }
}

