/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider;

import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.exceptions.ConfigProviderException;
import com.checkmarx.configprovider.readers.Processor;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigBeanFactory;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.naming.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigProvider.class);
    Map<String, Config> configurationMap = new HashMap<String, Config>();
    private static ConfigProvider instance = null;

    private ConfigProvider() {
    }

    public static ConfigProvider getInstance() {
        return Optional.ofNullable(instance).orElseGet(() -> {
            instance = new ConfigProvider();
            return instance;
        });
    }

    public void init(String uid, ConfigReader reader) throws ConfigurationException {
        Config config = Processor.load(reader);
        this.store(uid, config);
    }

    private void store(String uid, Config config) {
        this.configurationMap.put(uid, config);
    }

    public boolean hasAnyConfiguration(String uid) {
        return Optional.ofNullable(this.configurationMap.get(uid)).map(Config::root).map(ConfigObject::toConfig).map(config -> !config.isEmpty()).orElse(false);
    }

    public boolean hasConfiguration(String uid, String configSection) {
        return Optional.ofNullable(this.configurationMap.get(uid)).map(Config::root).map(ConfigObject::toConfig).map(config -> config.hasPath(configSection)).orElse(false);
    }

    public <T> T getConfiguration(String uid, String configSection, Class<T> clazz) {
        if (!this.hasConfiguration(uid, configSection)) {
            log.debug("No matching configuration for {} {}. returning null", (Object)uid, (Object)configSection);
            return null;
        }
        log.info("reading configuration {} into class {}", (Object)uid, (Object)clazz.getSimpleName());
        Config config = this.configurationMap.get(uid).root().toConfig();
        if (!config.isResolved()) {
            log.warn("reading configuration ({}) forced resolving the configuration", (Object)uid);
            config = config.resolve();
            this.store(uid, config);
        }
        config = config.getConfig(configSection);
        try {
            return (T)ConfigBeanFactory.create((Config)config, clazz);
        }
        catch (ConfigException e) {
            throw new ConfigProviderException(e.getMessage());
        }
    }

    public String getStringConfiguration(String uid, String configSection) {
        if (!this.hasConfiguration(uid, configSection)) {
            log.debug("No matching configuration for {} {}. returning null", (Object)uid, (Object)configSection);
            return null;
        }
        log.info("reading configuration {} ", (Object)uid);
        Config config = this.configurationMap.get(uid).root().toConfig();
        if (!config.isResolved()) {
            log.warn("reading configuration ({}) forced resolving the configuration", (Object)uid);
            config = config.resolve();
            this.store(uid, config);
        }
        return config.getString(configSection);
    }

    public void clear() {
        this.configurationMap.clear();
    }
}

