/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm.changelog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.redline_rpm.changelog.ChangelogEntry;
import org.redline_rpm.changelog.ChangelogParseException;
import org.redline_rpm.changelog.ChangelogParser;
import org.redline_rpm.header.Header;

public class ChangelogHandler {
    private final Header header;

    public ChangelogHandler(Header header) {
        this.header = header;
    }

    public void addChangeLog(File changelogFile) throws IOException, ChangelogParseException {
        FileInputStream changelog = new FileInputStream(changelogFile);
        ChangelogParser parser = new ChangelogParser();
        List<ChangelogEntry> entries = parser.parse(changelog);
        for (ChangelogEntry entry : entries) {
            this.addChangeLogEntry(entry);
        }
    }

    private void addChangeLogEntry(ChangelogEntry entry) {
        long epochMillis = entry.getChangeLogTime().getTime();
        long epochSecs = epochMillis / 1000L;
        int unixdate = (int)epochSecs;
        this.header.addOrAppendEntry(Header.HeaderTag.CHANGELOGTIME, new int[]{unixdate});
        this.header.addOrAppendEntry(Header.HeaderTag.CHANGELOGNAME, new String[]{entry.getUserMakingChange()});
        this.header.addOrAppendEntry(Header.HeaderTag.CHANGELOGTEXT, new String[]{entry.getDescription()});
    }
}

