/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.whitesource.fs.configuration.ScmConfiguration;
import org.whitesource.util.CxLogUtil;

public class ScmRepositoriesParser {
    private final Logger logger = CxLogUtil.getLogger(ScmRepositoriesParser.class);
    public static final String URL = "url";
    public static final String BRANCH = "branch";
    public static final String SCM_REPOSITORIES = "scmRepositories";

    public Collection<ScmConfiguration> parseRepositoriesFile(String fileName, String scmType, String scmPpk, String scmUser, String scmPassword) {
        block8: {
            LinkedList<ScmConfiguration> linkedList;
            FileInputStream is = new FileInputStream(fileName);
            try {
                String jsonText = IOUtils.toString((InputStream)is);
                JSONObject json = new JSONObject(jsonText);
                JSONArray arr = json.getJSONArray(SCM_REPOSITORIES);
                LinkedList<ScmConfiguration> configurationList = new LinkedList<ScmConfiguration>();
                arr.forEach(scm -> {
                    JSONObject obj = (JSONObject)scm;
                    String url = obj.getString(URL);
                    String branch = obj.getString(BRANCH);
                    String tag = obj.getString("tag");
                    configurationList.add(new ScmConfiguration(scmType, scmUser, scmPassword, scmPpk, url, branch, tag, null, false, 1));
                });
                linkedList = configurationList;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    this.logger.error("file Not Found: {}", (Object)fileName);
                    break block8;
                }
                catch (IOException e) {
                    this.logger.error("error getting file : {}", (Object)e.getMessage());
                }
            }
            ((InputStream)is).close();
            return linkedList;
        }
        return null;
    }
}

