/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.util.CxLogUtil;

public class ConfigurationSerializer<T> {
    private final Logger logger = CxLogUtil.getLogger(ConfigurationSerializer.class);
    private static ObjectMapper jsonMapper = new ObjectMapper();
    private static ObjectMapper jsonMapperWithoutNulls = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static ObjectMapper yamlMapperWithoutNulls = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public FSAConfiguration load(String fileInput) throws IOException {
        FSAConfiguration config = (FSAConfiguration)jsonMapper.readValue(new File(fileInput), FSAConfiguration.class);
        return config;
    }

    public boolean save(T object, String fileOutput, boolean includeNulls) {
        try {
            if (includeNulls) {
                jsonMapper.writeValue(new File(fileOutput), object);
            } else {
                jsonMapperWithoutNulls.writeValue(new File(fileOutput), object);
            }
            return true;
        }
        catch (IOException e) {
            this.logger.error("error saving configuration ", (Object[])e.getStackTrace());
            return false;
        }
    }

    public boolean saveYaml(T object, String fileOutput) {
        try {
            yamlMapperWithoutNulls.writeValue(new File(fileOutput), object);
            return true;
        }
        catch (IOException e) {
            this.logger.error("error saving configuration ", (Object[])e.getStackTrace());
            return false;
        }
    }

    public <T> String getAsString(T object, boolean includeNulls) {
        try {
            if (includeNulls) {
                return jsonMapperWithoutNulls.writeValueAsString(object);
            }
            return jsonMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            this.logger.error("error getting configuration ", (Throwable)e);
            return null;
        }
    }

    public static <T> Properties getAsProperties(T object) {
        Map map = (Map)jsonMapper.convertValue(object, Map.class);
        Properties properties = new Properties();
        ConfigurationSerializer.fillProperties(map, properties);
        return properties;
    }

    private static void fillProperties(Map<String, Object> map, Properties properties) {
        map.entrySet().forEach(entry -> {
            if (entry.getValue() != null) {
                if (entry.getValue() instanceof Map) {
                    ConfigurationSerializer.fillProperties((Map)entry.getValue(), properties);
                } else if (entry.getValue() instanceof ArrayList) {
                    properties.put(entry.getKey(), String.join((CharSequence)" ", (ArrayList)entry.getValue()));
                } else {
                    properties.put(entry.getKey(), entry.getValue().toString());
                }
            }
        });
    }

    public static <T> T getFromString(String json, Class<T> typeParameterClass, boolean includeNulls) {
        try {
            if (includeNulls) {
                Object config = jsonMapperWithoutNulls.readValue(json, typeParameterClass);
                return (T)config;
            }
            Object config = jsonMapper.readValue(json, typeParameterClass);
            return (T)config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

