/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.sbt;

import java.io.File;
import org.slf4j.Logger;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.IBomParser;
import org.whitesource.agent.dependency.resolver.sbt.IvyReport;
import org.whitesource.agent.utils.JaxbUtil;
import org.whitesource.util.CxLogUtil;

public class SbtBomParser
implements IBomParser {
    private final Logger logger = CxLogUtil.getLogger(SbtBomParser.class);

    @Override
    public BomFile parseBomFile(String bomPath) {
        File bomFile = new File(bomPath);
        if (bomFile.isFile()) {
            try {
                IvyReport ivyReport = JaxbUtil.readFromPath(bomFile, IvyReport.class);
                String groupId = ivyReport.getInfo().getGroupId();
                String artifactId = ivyReport.getInfo().getArtifactId();
                String version = ivyReport.getInfo().getVersion();
                return new BomFile(groupId, artifactId, version, bomPath);
            }
            catch (Exception e) {
                this.logger.warn("Couldn't parse {}, {}", (Object)bomPath, (Object)e.getMessage());
                this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
            }
        }
        return null;
    }
}

