/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.maven;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.IBomParser;
import org.whitesource.util.CxLogUtil;

public class MavenPomParser
implements IBomParser {
    private final Logger logger = CxLogUtil.getLogger(MavenPomParser.class);
    private final MavenXpp3Reader reader = new MavenXpp3Reader();

    @Override
    public BomFile parseBomFile(String bomPath) {
        Model model = null;
        try (FileInputStream bomIS = new FileInputStream(bomPath);){
            model = this.reader.read((InputStream)bomIS);
        }
        catch (IOException | XmlPullParserException e) {
            this.logger.debug("Could not parse pom file " + bomPath);
        }
        if (model != null && model.getArtifactId() != null) {
            return new BomFile(model.getGroupId(), model.getArtifactId(), model.getVersion(), bomPath);
        }
        return null;
    }
}

