/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.UrlValidator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.whitesource.agent.DependencyInfoFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.utils.FilesUtils;
import org.whitesource.util.CxLogUtil;

public class HtmlDependencyResolver
extends AbstractDependencyResolver {
    private final Logger logger = CxLogUtil.getLogger(HtmlDependencyResolver.class);
    public static final List<String> htmlTypeExtensions = Arrays.asList("htm", "html", "shtml", "xhtml", "jsp", "asp", "do", "aspx");
    public final String[] includesPattern = new String[htmlTypeExtensions.size()];
    public static final String WHITESOURCE_HTML_RESOLVER = "whitesource-html-resolver";
    public static final String URL_PATH = "://";
    private final Pattern patternOfFirstLetter = Pattern.compile("[a-zA-Z].*");
    private final Pattern patternOfLegitSrcUrl = Pattern.compile("<%.*%>");

    public HtmlDependencyResolver() {
        int i = 0;
        for (String extension : htmlTypeExtensions) {
            this.includesPattern[i++] = "**/*." + extension;
        }
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        for (String htmlFile : bomFiles) {
            try {
                Document htmlFileDocument = Jsoup.parse((File)new File(htmlFile), (String)"UTF-8");
                Elements script = htmlFileDocument.getElementsByAttribute("src");
                LinkedList<String> scriptUrls = new LinkedList<String>();
                for (Element srcLink : script) {
                    String srcUrl;
                    String src = srcLink.attr("src");
                    if (src == null || !this.isLegitSrcUrl(src) || (srcUrl = this.fixUrls(src)) == null) continue;
                    scriptUrls.add(srcUrl);
                }
                dependencies.addAll(this.collectJsFilesAndCalcHashes(scriptUrls, htmlFile));
            }
            catch (IOException e) {
                this.logger.debug("Cannot parse the html file: {}", (Object)htmlFile);
            }
        }
        return new ResolutionResult(dependencies, this.getExcludes(), this.getDependencyType(), topLevelFolder);
    }

    private boolean isLegitSrcUrl(String srcUrl) {
        Matcher matcher;
        if (srcUrl.contains("?")) {
            String[] srcURLSplit = srcUrl.split("\\?");
            srcUrl = srcURLSplit[0];
        }
        return srcUrl.endsWith(".js") && !(matcher = this.patternOfLegitSrcUrl.matcher(srcUrl)).find();
    }

    private List<DependencyInfo> collectJsFilesAndCalcHashes(List<String> scriptUrls, String htmlFilePath) {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        String tempFolder = new FilesUtils().createTmpFolder(false, WHITESOURCE_HTML_RESOLVER);
        File tempFolderFile = new File(tempFolder);
        String dependencyFileName = null;
        if (tempFolder != null) {
            for (String scriptUrl : scriptUrls) {
                try {
                    URL urlScopeDep = new URL(scriptUrl);
                    String fileName = scriptUrl.substring(scriptUrl.lastIndexOf("/") + 1);
                    dependencyFileName = tempFolder + File.separator + fileName;
                    HtmlDependencyResolver.downloadFile(urlScopeDep, new File(dependencyFileName));
                    DependencyInfoFactory dependencyInfoFactory = new DependencyInfoFactory();
                    DependencyInfo dependencyInfo = dependencyInfoFactory.createDependencyInfo(tempFolderFile, fileName);
                    if (dependencyInfo == null) continue;
                    dependencies.add(dependencyInfo);
                    dependencyInfo.setSystemPath(htmlFilePath);
                }
                catch (MalformedURLException e) {
                    this.logger.debug("Failed creating URL of {}", (Object)scriptUrl);
                }
                catch (IOException e) {
                    this.logger.debug("Failed writing to file {}", dependencyFileName);
                }
            }
            FilesUtils.deleteDirectory(tempFolderFile);
        }
        return dependencies;
    }

    private String fixUrls(String scriptUrl) {
        UrlValidator validator = new UrlValidator();
        if (validator.isValid(scriptUrl)) {
            return scriptUrl;
        }
        Matcher matcher = this.patternOfFirstLetter.matcher(scriptUrl);
        matcher.find();
        if (matcher.group(0) != null) {
            return "http://" + matcher.group(0);
        }
        return null;
    }

    public static void downloadFile(URL url, File outputFile) throws IOException {
        try (InputStream in = url.openStream();
             ReadableByteChannel rbc = Channels.newChannel(in);
             FileOutputStream fos = new FileOutputStream(outputFile);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    public static String downloadFileAsString(URL url) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStream in = url.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    @Override
    protected Collection<String> getExcludes() {
        return new ArrayList<String>();
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return htmlTypeExtensions;
    }

    @Override
    protected DependencyType getDependencyType() {
        return null;
    }

    @Override
    protected String getDependencyTypeName() {
        return "html".toUpperCase();
    }

    @Override
    protected boolean printResolvedFolder() {
        return false;
    }

    @Override
    protected String[] getBomPattern() {
        return this.includesPattern;
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new ArrayList<String>();
    }
}

