/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.dependency.resolver.docker.AbstractParser;
import org.whitesource.agent.dependency.resolver.docker.Package;

public class AlpineParser
extends AbstractParser {
    private static final String PACKAGE = "P";
    private static final String VERSION = "V";
    private static final String ARCHITECTURE = "A";
    private static final String ALPINE_PACKAGE_PATTERN = "{0}.apk";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Collection<DependencyInfo> parse(File file) {
        BufferedReader br = null;
        FileReader fr = null;
        LinkedList<DependencyInfo> dependencyInfos = new LinkedList<DependencyInfo>();
        try {
            fr = new FileReader(file.getAbsoluteFile());
            br = new BufferedReader(fr);
            String line = null;
            Package packageInfo = new Package();
            while ((line = br.readLine()) != null) {
                if (!line.isEmpty()) {
                    if (packageInfo.getPackageName() != null && packageInfo.getVersion() != null && packageInfo.getArchitecture() != null) continue;
                    String[] lineSplit = line.split(":");
                    String dependencyParameter = lineSplit[1].trim();
                    switch (lineSplit[0]) {
                        case "P": {
                            packageInfo.setPackageName(dependencyParameter);
                            break;
                        }
                        case "V": {
                            packageInfo.setVersion(dependencyParameter);
                            break;
                        }
                        case "A": {
                            packageInfo.setArchitecture(dependencyParameter);
                            break;
                        }
                    }
                    continue;
                }
                DependencyInfo dependencyInfo = this.createDependencyInfo(packageInfo);
                packageInfo = new Package();
                dependencyInfos.add(dependencyInfo);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AlpineParser.closeStream(br, fr);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    AlpineParser.closeStream(br, fr);
                    throw throwable;
                }
            }
            AlpineParser.closeStream(br, fr);
        }
        AlpineParser.closeStream(br, fr);
        return dependencyInfos;
    }

    @Override
    public File findFile(String[] files, String filename) {
        for (String filepath : files) {
            if (!filepath.endsWith(filename)) continue;
            return new File(filepath);
        }
        return null;
    }

    private DependencyInfo createDependencyInfo(Package packageInfo) {
        DependencyInfo dependencyInfo = null;
        if (StringUtils.isNotBlank((String)packageInfo.getPackageName()) && StringUtils.isNotBlank((String)packageInfo.getVersion()) && StringUtils.isNotBlank((String)packageInfo.getArchitecture())) {
            dependencyInfo = new DependencyInfo(null, MessageFormat.format(ALPINE_PACKAGE_PATTERN, packageInfo.getPackageName() + "-" + packageInfo.getVersion()), packageInfo.getVersion() + "-" + packageInfo.getArchitecture());
        }
        if (dependencyInfo != null) {
            return dependencyInfo;
        }
        return null;
    }
}

