/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.bower;

import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.npm.NpmLsJsonDependencyCollector;
import org.whitesource.util.CxLogUtil;

public class BowerLsJsonDependencyCollector
extends NpmLsJsonDependencyCollector {
    private final Logger logger = CxLogUtil.getLogger(BowerLsJsonDependencyCollector.class);
    private static final String BOWER_COMMAND = NpmLsJsonDependencyCollector.isWindows() ? "bower.cmd" : "bower";
    private static final String PKG_META = "pkgMeta";
    private static final String TYPE = "type";

    public BowerLsJsonDependencyCollector(long npmTimeoutDependenciesCollector) {
        super(false, npmTimeoutDependenciesCollector, false, false);
    }

    @Override
    protected String[] getInstallParams() {
        return new String[]{BOWER_COMMAND, "install"};
    }

    @Override
    protected String[] getLsCommandParamsJson() {
        return new String[]{BOWER_COMMAND, "ls", "--json"};
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected DependencyInfo getDependency(String dependencyAlias, JSONObject jsonObject) {
        String version = "";
        String name = "";
        boolean unmetDependency = false;
        if (jsonObject.has("missing") && jsonObject.getBoolean("missing")) {
            this.unmetDependencyLog(dependencyAlias);
            return null;
        }
        if (jsonObject.has(PKG_META)) {
            JSONObject metaData = jsonObject.getJSONObject(PKG_META);
            if (metaData.has("_resolution")) {
                JSONObject resolution = metaData.getJSONObject("_resolution");
                String resolutionType = resolution.getString(TYPE);
                if (metaData.has("name")) {
                    name = metaData.getString("name");
                } else {
                    unmetDependency = true;
                }
                if (!resolutionType.equals("tag") && !resolutionType.equals("version")) {
                    this.logger.warn("We were not able to allocate the bower version for '{}' in you bower.json file.At the moment we only support tag, so please modify your bower.json accordingly and run the plugin again.", (Object)name);
                    return null;
                }
                version = metaData.getString("version");
            } else {
                unmetDependency = true;
            }
        } else {
            unmetDependency = true;
        }
        if (unmetDependency) {
            this.unmetDependencyLog(dependencyAlias);
            return null;
        }
        DependencyInfo dependency = new DependencyInfo();
        dependency.setGroupId(name);
        dependency.setArtifactId(name);
        dependency.setVersion(version);
        dependency.setDependencyType(DependencyType.BOWER);
        return dependency;
    }

    @Override
    protected void getDependencies(JSONObject jsonObject, String rootDirectory, Collection<DependencyInfo> dependencies) {
        JSONObject dependenciesJsonObject;
        if (jsonObject.has("dependencies") && (dependenciesJsonObject = jsonObject.getJSONObject("dependencies")) != null) {
            for (String dependencyAlias : dependenciesJsonObject.keySet()) {
                JSONObject dependencyJsonObject = dependenciesJsonObject.getJSONObject(dependencyAlias);
                if (dependencyJsonObject.keySet().isEmpty()) {
                    this.logger.debug("Dependency {} has no JSON content", (Object)dependencyAlias);
                    continue;
                }
                DependencyInfo dependency = this.getDependency(dependencyAlias, dependencyJsonObject);
                if (dependency == null) continue;
                dependencies.add(dependency);
                this.logger.debug("Collect child dependencies of {}", (Object)dependencyAlias);
                ArrayList<DependencyInfo> childDependencies = new ArrayList<DependencyInfo>();
                this.getDependencies(dependencyJsonObject, rootDirectory, childDependencies);
                dependency.getChildren().addAll(childDependencies);
            }
        }
    }

    private void unmetDependencyLog(String dependencyAlias) {
        this.logger.warn("Unmet dependency --> {}", (Object)dependencyAlias);
    }
}

