/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.IBomParser;
import org.whitesource.util.CxLogUtil;

public abstract class BomParser
implements IBomParser {
    private final Logger logger = CxLogUtil.getLogger(BomParser.class);

    @Override
    public BomFile parseBomFile(String bomPath) {
        BomFile bomFile = null;
        String json = null;
        try (FileInputStream is = new FileInputStream(bomPath);){
            json = IOUtils.toString((InputStream)is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            this.logger.error("file Not Found: {}", (Object)bomPath);
        }
        catch (IOException e) {
            this.logger.error("error getting file : {}", (Object)e.getMessage());
        }
        if (json != null) {
            try {
                bomFile = this.parseBomFile(json, bomPath);
            }
            catch (Exception e) {
                this.logger.debug("Invalid file {}", (Object)bomPath);
            }
        }
        return bomFile;
    }

    protected abstract BomFile parseBomFile(String var1, String var2);

    protected abstract String getFilename(String var1, String var2);
}

