/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.utils.ZipUtils;

public class OfflineUpdateRequest {
    public static final String UTF_8 = "UTF-8";
    private UpdateInventoryRequest request;

    public OfflineUpdateRequest(UpdateInventoryRequest request) {
        this.request = request;
    }

    public File generate(File outputDir, boolean zip, boolean prettyJson) throws IOException {
        String json;
        if (this.request == null) {
            throw new IllegalStateException("Update inventory request is null");
        }
        File workDir = new File(outputDir, "whitesource");
        if (!workDir.exists() && !workDir.mkdir()) {
            throw new IOException("Unable to make output directory: " + workDir);
        }
        if (zip) {
            json = new Gson().toJson((Object)this.request);
            json = ZipUtils.compressString((String)json);
        } else if (prettyJson) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            json = gson.toJson((Object)this.request);
        } else {
            json = new Gson().toJson((Object)this.request);
        }
        File requestFile = new File(workDir, "update-request.txt");
        FileUtils.writeStringToFile((File)requestFile, (String)json, (String)UTF_8);
        return requestFile;
    }
}

