/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sca.utils.fingerprints;

import com.cx.restclient.sca.utils.fingerprints.CxSCAFileFingerprints;
import com.cx.restclient.sca.utils.fingerprints.CxSCAScanFingerprints;
import com.cx.restclient.sca.utils.fingerprints.Sha1SignatureCalculator;
import com.cx.restclient.sca.utils.fingerprints.SignatureCalculator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;

public class FingerprintCollector {
    private static final String DEFAULT_FINGERPRINT_FILENAME = "CxSCAFingerprints.json";
    private final SignatureCalculator sha1SignatureCalculator;
    private final Logger log;

    public FingerprintCollector(Logger log) {
        this.log = log;
        this.sha1SignatureCalculator = new Sha1SignatureCalculator();
    }

    public CxSCAScanFingerprints collectFingerprints(String baseDir, List<String> files) {
        this.log.info(String.format("Started fingerprint collection on %s", baseDir));
        CxSCAScanFingerprints scanFingerprints = new CxSCAScanFingerprints();
        for (String filePath : files) {
            Path fullFilePath = Paths.get(baseDir, filePath);
            try {
                this.log.debug(String.format("Calculating signatures for file %s", fullFilePath));
                byte[] fileContent = Files.readAllBytes(fullFilePath);
                CxSCAFileFingerprints fingerprints = new CxSCAFileFingerprints(filePath, Files.size(fullFilePath));
                fingerprints.addFileSignature(this.sha1SignatureCalculator.calculateSignature(fileContent));
                scanFingerprints.addFileFingerprints(fingerprints);
            }
            catch (IOException e) {
                this.log.error(String.format("Failed calculating file signature: %s", fullFilePath.toString()), (Throwable)e);
            }
        }
        this.log.info(String.format("Calculated fingerprints for %d files", scanFingerprints.getFingerprints().size()));
        scanFingerprints.setTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return scanFingerprints;
    }

    public void writeScanFingerprintsFile(CxSCAScanFingerprints scanFingerprints, String path) throws IOException {
        long fingerprintCount = scanFingerprints.getFingerprints().size();
        if (fingerprintCount == 0L) {
            this.log.info("No supported files for fingerprinting found in this scan");
        }
        String fingerprintFilePath = path;
        File targetLocation = new File(path);
        if (targetLocation.isDirectory()) {
            fingerprintFilePath = Paths.get(path, DEFAULT_FINGERPRINT_FILENAME).toString();
        }
        this.log.info(String.format("Writing %d file signatures to fingerprint file: %s", fingerprintCount, fingerprintFilePath));
        ObjectMapper objectMapper = new ObjectMapper();
        File fingerprintFile = new File(fingerprintFilePath);
        objectMapper.writeValue(fingerprintFile, (Object)scanFingerprints);
    }

    public static String getFingerprintsAsJsonString(CxSCAScanFingerprints scanFingerprints) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString((Object)scanFingerprints);
    }
}

