/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sca.utils;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CxSCAResolverUtils {
    public static Map<String, String> shortArgumentsMap() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-a", "--account");
        args.put("-c", "--config-path");
        args.put("-e", "--excludes");
        args.put("-n", "--project-name");
        args.put("-p", "--password");
        args.put("-r", "--resolver-result-path");
        args.put("-s", "--scan-path");
        args.put("-t", "--project-teams");
        args.put("-u", "--username");
        args.put("-v", "--version");
        return Collections.unmodifiableMap(args);
    }

    public static Map<String, String> parseArguments(String text) throws ParseException {
        HashMap<String, String> parsed = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)(text = text.trim()))) {
            return parsed;
        }
        String[] arguments = text.split("\\s+");
        Map<String, String> shortArgs = CxSCAResolverUtils.shortArgumentsMap();
        int parsePos = 0;
        int i = 0;
        while (i < arguments.length) {
            String arg = arguments[i];
            ArrayList<String> valueBuffer = new ArrayList<String>();
            if (!(arg.startsWith("-") && arg.length() == 2 || arg.startsWith("--"))) {
                throw new ParseException("Could not parse provided arguments: " + text, parsePos);
            }
            if (arg.contains("=")) {
                String[] parts = arg.split("=", 2);
                arg = parts[0];
                valueBuffer.add(parts[1]);
            }
            parsePos += arg.length() + 1;
            if (shortArgs.containsKey(arg)) {
                arg = shortArgs.get(arg);
            }
            ++i;
            while (!(i >= arguments.length || arguments[i].startsWith("-") && arguments[i].length() == 2 || arguments[i].startsWith("--"))) {
                valueBuffer.add(arguments[i]);
                ++i;
            }
            String value = null;
            if (!valueBuffer.isEmpty()) {
                value = String.join((CharSequence)" ", valueBuffer);
                parsePos += value.length() + 1;
                if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
            }
            parsed.put(arg, value);
        }
        return parsed;
    }
}

