/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils.zip;

import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.PathFilter;
import com.cx.restclient.sast.utils.zip.CxZip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public abstract class CxZipUtils {
    private static File tempExtractedDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] getZippedSources(CxScanConfig config, PathFilter filter, String sourceDir, Logger log, String prefix) throws IOException {
        try {
            if (config.getZipFile() != null) {
                try {
                    sourceDir = CxZipUtils.extractZipToTempDirectory(config.getZipFile().getAbsolutePath(), log, prefix);
                }
                catch (IOException e) {
                    log.error("Failed to extract ZIP file: {}", (Object)config.getZipFile().getAbsolutePath(), (Object)e);
                    throw new IOException("Error extracting ZIP file for scanning", e);
                }
            } else {
                log.info("Uploading the zipped source code.");
            }
            log.debug("----------------------------------- Start zipping files :------------------------------------");
            Long maxZipSize = config.getMaxZipSize() != null ? (long)(config.getMaxZipSize() * 1024 * 1024) : 0x80000000L;
            CxZip cxZip = new CxZip("zippedSource", maxZipSize, log);
            byte[] zipFile = cxZip.zipWorkspaceFolder(new File(sourceDir), filter);
            log.debug("sourceDir:" + sourceDir);
            log.debug("----------------------------------- Finish zipping files :------------------------------------");
            byte[] byArray = zipFile;
            return byArray;
        }
        finally {
            CxZipUtils.cleanupTempExtractedDir(log);
        }
    }

    public static String extractZipToTempDirectory(String zipFilePath, Logger log, String prefix) throws IOException {
        tempExtractedDir = Files.createTempDirectory(prefix + "_extracted_", new FileAttribute[0]).toFile();
        log.info("Created temporary directory: {}", (Object)tempExtractedDir.getAbsolutePath());
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry zipEntry;
            byte[] buffer = new byte[1024];
            while ((zipEntry = zis.getNextEntry()) != null) {
                File newFile = new File(tempExtractedDir, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory: " + newFile);
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory: " + parent);
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
        log.info("Successfully extracted ZIP file to: {}", (Object)tempExtractedDir.getAbsolutePath());
        return tempExtractedDir.getAbsolutePath();
    }

    public static boolean isZip(String effectiveDir, Logger log) {
        if (effectiveDir == null) {
            log.info("Source directory path is null");
            return false;
        }
        File file = new File(effectiveDir);
        if (!file.exists()) {
            log.info("Source path does not exist: {}", (Object)effectiveDir);
            return false;
        }
        if (!file.isFile()) {
            log.info("Source path is not a file: {}", (Object)effectiveDir);
            return false;
        }
        return effectiveDir.toLowerCase().endsWith(".zip");
    }

    public static void cleanupTempExtractedDir(Logger log) {
        if (tempExtractedDir != null && tempExtractedDir.exists()) {
            try {
                log.info("Cleaning up temporary extracted directory: {}", (Object)tempExtractedDir.getAbsolutePath());
                FileUtils.deleteDirectory((File)tempExtractedDir);
                tempExtractedDir = null;
            }
            catch (IOException e) {
                log.error("Failed to delete temporary extracted directory: {}", (Object)tempExtractedDir.getAbsolutePath(), (Object)e);
            }
        }
    }
}

