/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils.zip;

import com.cx.restclient.dto.PathFilter;
import com.cx.restclient.sast.utils.zip.ZipListener;
import com.cx.restclient.sast.utils.zip.Zipper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class CxZip {
    private long maxZipSizeInBytes = 0x80000000L;
    private int numOfZippedFiles = 0;
    private String tempFileName;
    private Logger log;

    public CxZip(String tempFileName, long maxZipSizeInBytes, Logger log) {
        this.tempFileName = tempFileName;
        this.log = log;
        this.maxZipSizeInBytes = maxZipSizeInBytes;
    }

    public byte[] zipWorkspaceFolder(File baseDir, PathFilter filter) throws IOException {
        byte[] zipFileBA;
        this.log.debug("Zipping workspace: '" + baseDir + "'");
        ZipListener zipListener = new ZipListener(){

            @Override
            public void updateProgress(String fileName, long size) {
                CxZip.this.numOfZippedFiles++;
                CxZip.this.log.debug("Zipping (" + FileUtils.byteCountToDisplaySize((long)size) + "): " + fileName);
            }
        };
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try {
                new Zipper(this.log).zip(baseDir, filter.getIncludes(), filter.getExcludes(), byteArrayOutputStream, this.maxZipSizeInBytes, zipListener);
            }
            catch (Zipper.MaxZipSizeReached e) {
                throw new IOException("Reached maximum upload size limit of " + FileUtils.byteCountToDisplaySize((long)this.maxZipSizeInBytes));
            }
            catch (Zipper.NoFilesToZip e) {
                throw new IOException("No files to zip");
            }
            this.log.debug("Zipping complete with " + this.numOfZippedFiles + " files, total compressed size: " + FileUtils.byteCountToDisplaySize((long)byteArrayOutputStream.size()));
            zipFileBA = byteArrayOutputStream.toByteArray();
        }
        return zipFileBA;
    }

    public CxZip setMaxZipSizeInBytes(long maxZipSizeInBytes) {
        this.maxZipSizeInBytes = maxZipSizeInBytes;
        return this;
    }

    public CxZip setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
        return this;
    }

    public String getTempFileName() {
        return this.tempFileName;
    }
}

