/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.httpClient.utils;

import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;

public abstract class HttpClientHelper {
    private HttpClientHelper() {
    }

    public static <T> T convertToObject(HttpResponse response, Class<T> responseType, boolean isCollection) throws IOException, CxClientException {
        if (responseType != null && responseType.isInstance(response)) {
            return (T)response;
        }
        if (responseType != null && responseType.isAssignableFrom(response.getClass())) {
            return (T)response;
        }
        if (responseType == null || response.getEntity() == null || response.getEntity().getContentLength() == 0L) {
            return null;
        }
        if (responseType.equals(byte[].class)) {
            return (T)IOUtils.toByteArray((InputStream)response.getEntity().getContent());
        }
        if (isCollection) {
            return HttpClientHelper.convertToCollectionObject(response, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, responseType));
        }
        return HttpClientHelper.convertToStrObject(response, responseType);
    }

    private static <T> T convertToStrObject(HttpResponse response, Class<T> valueType) throws CxClientException {
        ObjectMapper mapper = HttpClientHelper.getObjectMapper();
        try {
            if (response.getEntity() == null) {
                return null;
            }
            String json = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
            if (valueType.equals(String.class)) {
                return (T)json;
            }
            return (T)mapper.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new CxClientException("Failed to parse json response: " + e.getMessage());
        }
    }

    public static String convertToJson(Object o) throws CxClientException {
        ObjectMapper mapper = HttpClientHelper.getObjectMapper();
        try {
            return mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new CxClientException("Failed convert object to json: " + e.getMessage());
        }
    }

    public static StringEntity convertToStringEntity(Object o) throws CxClientException, UnsupportedEncodingException {
        return new StringEntity(HttpClientHelper.convertToJson(o));
    }

    private static <T> T convertToCollectionObject(HttpResponse response, JavaType javaType) throws CxClientException {
        ObjectMapper mapper = HttpClientHelper.getObjectMapper();
        try {
            String json = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
            return (T)mapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new CxClientException("Failed to parse json response: " + e.getMessage(), e);
        }
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper result = new ObjectMapper();
        result.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return result;
    }

    public static void validateResponse(HttpResponse response, int expectedStatus, String message) throws CxClientException {
        int actualStatusCode = response.getStatusLine().getStatusCode();
        if (actualStatusCode != expectedStatus) {
            String responseBody = HttpClientHelper.extractResponseBody(response);
            String readableBody = responseBody.replace("{", "").replace("}", "").replace(System.getProperty("line.separator"), " ").replace("  ", "");
            String exceptionMessage = String.format("Status code: %d, message: '%s', response body: %s", actualStatusCode, message, readableBody);
            throw new CxHTTPClientException(actualStatusCode, exceptionMessage, responseBody);
        }
    }

    public static String extractResponseBody(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] getSBOMReport(CxHttpClient httpClient, String fileUrl) throws IOException {
        byte[] scaReport = httpClient.getExternalRequest(fileUrl, "*/*", byte[].class, 200, " SCA Report: ");
        if (scaReport != null && scaReport.length > 0) {
            return scaReport;
        }
        throw new IOException("Failed to fetch file: " + fileUrl);
    }
}

