/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.configuration;

import com.cx.restclient.exception.CxClientException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileLoader {
    private static final Logger log = LoggerFactory.getLogger(PropertyFileLoader.class);
    private static final String DEFAULT_FILENAME = "common.properties";
    private static final AtomicReference<Object> defaultInstance = new AtomicReference();
    private final Properties properties;

    public PropertyFileLoader(String ... filenames) {
        if (filenames.length == 0) {
            throw new CxClientException("Please provide at least one filename.");
        }
        this.properties = new Properties();
        for (String filename : filenames) {
            Properties singleFileProperties = this.getPropertiesFromResource(filename);
            this.properties.putAll((Map<?, ?>)singleFileProperties);
        }
    }

    private Properties getPropertiesFromResource(String resourceName) {
        Properties result = new Properties();
        log.debug("Loading properties from resource: {}", (Object)resourceName);
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(resourceName);){
            if (input != null) {
                result.load(input);
            } else {
                log.warn("Unable to find resource: {}, skipping.", (Object)resourceName);
            }
        }
        catch (IOException e) {
            throw new CxClientException(String.format("Error loading the '%s' resource.", resourceName), e);
        }
        return result;
    }

    public String get(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyFileLoader getDefaultInstance() {
        Object value = defaultInstance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultInstance;
            synchronized (atomicReference) {
                value = defaultInstance.get();
                if (value == null) {
                    PropertyFileLoader actualValue = new PropertyFileLoader(DEFAULT_FILENAME);
                    value = actualValue == null ? defaultInstance : actualValue;
                    defaultInstance.set(value);
                }
            }
        }
        return (PropertyFileLoader)(value == defaultInstance ? null : value);
    }
}

