/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common.summary;

import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.ast.dto.sca.report.PolicyEvaluation;
import com.cx.restclient.common.summary.DependencyScanResult;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.Policy;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.scansummary.ScanSummary;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.sast.dto.SASTResults;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.stream.Collectors;

public abstract class SummaryUtils {
    private SummaryUtils() {
    }

    public static String generateSummary(SASTResults sastResults, OSAResults osaResults, AstScaResults scaResults, CxScanConfig config) throws IOException, TemplateException {
        Configuration cfg = new Configuration(new Version("2.3.23"));
        cfg.setClassForTemplateLoading(SummaryUtils.class, "/com/cx/report");
        Template template = cfg.getTemplate("report.ftl");
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("config", config);
        templateData.put("sast", sastResults != null ? sastResults : new SASTResults());
        templateData.put("osa", osaResults != null ? osaResults : new OSAResults());
        templateData.put("sca", scaResults != null ? scaResults : new AstScaResults());
        DependencyScanResult dependencyScanResult = SummaryUtils.resolveDependencyResult(osaResults, scaResults);
        if (dependencyScanResult == null) {
            dependencyScanResult = new DependencyScanResult();
            if (config.isAstScaEnabled()) {
                dependencyScanResult.setScannerType(ScannerType.AST_SCA);
            } else if (config.isOsaEnabled()) {
                dependencyScanResult.setScannerType(ScannerType.OSA);
            }
        }
        templateData.put("dependencyResult", dependencyScanResult);
        ScanSummary scanSummary = new ScanSummary(config, sastResults, osaResults, scaResults);
        boolean buildFailed = false;
        boolean policyViolated = false;
        int policyViolatedCount = 0;
        if (config.isSastEnabled()) {
            if (sastResults != null && sastResults.isSastResultsReady()) {
                boolean sastThresholdExceeded = scanSummary.isSastThresholdExceeded();
                boolean sastNewResultsExceeded = scanSummary.isSastThresholdForNewResultsExceeded();
                templateData.put("sastThresholdExceeded", sastThresholdExceeded);
                templateData.put("sastNewResultsExceeded", sastNewResultsExceeded);
                buildFailed = sastThresholdExceeded || sastNewResultsExceeded;
                float maxCount = Math.max(sastResults.getHigh(), Math.max(sastResults.getMedium(), sastResults.getLow()));
                float sastBarNorm = maxCount * 10.0f / 9.0f;
                float sastCriticalTotalHeight = (float)sastResults.getCritical() / sastBarNorm * 238.0f;
                float sastCriticalNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewCritical(), sastResults.getCritical(), sastCriticalTotalHeight);
                float sastCriticalRecurrentHeight = sastCriticalTotalHeight - sastCriticalNewHeight;
                templateData.put("sastCriticalTotalHeight", Float.valueOf(sastCriticalTotalHeight));
                templateData.put("sastCriticalNewHeight", Float.valueOf(sastCriticalNewHeight));
                templateData.put("sastCriticalRecurrentHeight", Float.valueOf(sastCriticalRecurrentHeight));
                float sastHighTotalHeight = (float)sastResults.getHigh() / sastBarNorm * 238.0f;
                float sastHighNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewHigh(), sastResults.getHigh(), sastHighTotalHeight);
                float sastHighRecurrentHeight = sastHighTotalHeight - sastHighNewHeight;
                templateData.put("sastHighTotalHeight", Float.valueOf(sastHighTotalHeight));
                templateData.put("sastHighNewHeight", Float.valueOf(sastHighNewHeight));
                templateData.put("sastHighRecurrentHeight", Float.valueOf(sastHighRecurrentHeight));
                float sastMediumTotalHeight = (float)sastResults.getMedium() / sastBarNorm * 238.0f;
                float sastMediumNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewMedium(), sastResults.getMedium(), sastMediumTotalHeight);
                float sastMediumRecurrentHeight = sastMediumTotalHeight - sastMediumNewHeight;
                templateData.put("sastMediumTotalHeight", Float.valueOf(sastMediumTotalHeight));
                templateData.put("sastMediumNewHeight", Float.valueOf(sastMediumNewHeight));
                templateData.put("sastMediumRecurrentHeight", Float.valueOf(sastMediumRecurrentHeight));
                float sastLowTotalHeight = (float)sastResults.getLow() / sastBarNorm * 238.0f;
                float sastLowNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewLow(), sastResults.getLow(), sastLowTotalHeight);
                float sastLowRecurrentHeight = sastLowTotalHeight - sastLowNewHeight;
                templateData.put("sastLowTotalHeight", Float.valueOf(sastLowTotalHeight));
                templateData.put("sastLowNewHeight", Float.valueOf(sastLowNewHeight));
                templateData.put("sastLowRecurrentHeight", Float.valueOf(sastLowRecurrentHeight));
            } else {
                buildFailed = true;
            }
        }
        if (config.isOsaEnabled() || config.isAstScaEnabled()) {
            if (dependencyScanResult != null && dependencyScanResult.isResultReady()) {
                boolean thresholdExceeded = scanSummary.isOsaThresholdExceeded();
                templateData.put("dependencyThresholdExceeded", thresholdExceeded);
                buildFailed = config.isSastEnabled() ? (buildFailed |= thresholdExceeded || buildFailed) : (buildFailed |= thresholdExceeded);
                int dependencyCritical = dependencyScanResult.getCriticalVulnerability();
                int dependencyHigh = dependencyScanResult.getHighVulnerability();
                int dependencyMedium = dependencyScanResult.getMediumVulnerability();
                int dependencyLow = dependencyScanResult.getLowVulnerability();
                float dependencyMaxCount = Math.max(dependencyHigh, Math.max(dependencyMedium, dependencyLow));
                float dependencyBarNorm = dependencyMaxCount * 10.0f / 9.0f;
                float dependencyCriticalTotalHeight = (float)dependencyCritical / dependencyBarNorm * 238.0f;
                float dependencyHighTotalHeight = (float)dependencyHigh / dependencyBarNorm * 238.0f;
                float dependencyMediumTotalHeight = (float)dependencyMedium / dependencyBarNorm * 238.0f;
                float dependencyLowTotalHeight = (float)dependencyLow / dependencyBarNorm * 238.0f;
                templateData.put("dependencyCriticalTotalHeight", Float.valueOf(dependencyCriticalTotalHeight));
                templateData.put("dependencyHighTotalHeight", Float.valueOf(dependencyHighTotalHeight));
                templateData.put("dependencyMediumTotalHeight", Float.valueOf(dependencyMediumTotalHeight));
                templateData.put("dependencyLowTotalHeight", Float.valueOf(dependencyLowTotalHeight));
            } else {
                buildFailed = true;
            }
        }
        if ((config.isSastEnabled() || config.isOsaEnabled()) && config.getEnablePolicyViolations()) {
            HashMap<String, String> policies = new HashMap<String, String>();
            if (Boolean.TRUE.equals(config.isSastEnabled()) && sastResults != null && sastResults.getSastPolicies() != null && !sastResults.getSastPolicies().isEmpty()) {
                policyViolated = true;
                policies.putAll(sastResults.getSastPolicies().stream().collect(Collectors.toMap(Policy::getPolicyName, Policy::getRuleName, (left, right) -> left)));
            }
            if (Boolean.TRUE.equals(config.isOsaEnabled()) && osaResults != null && osaResults.getOsaPolicies() != null && !osaResults.getOsaPolicies().isEmpty()) {
                policyViolated = true;
                policies.putAll(osaResults.getOsaPolicies().stream().collect(Collectors.toMap(Policy::getPolicyName, Policy::getRuleName, (left, right) -> left)));
            }
            if (scanSummary.isPolicyViolated()) {
                buildFailed = true;
                policyViolated = true;
            }
            String policyLabel = (policyViolatedCount = policies.size()) == 1 ? "Policy" : "Policies";
            templateData.put("policyLabel", policyLabel);
            templateData.put("policyViolatedCount", policyViolatedCount);
        }
        if (config.isAstScaEnabled() && config.getEnablePolicyViolationsSCA()) {
            HashMap<String, String> policies = new HashMap<String, String>();
            if (Boolean.TRUE.equals(config.isAstScaEnabled()) && scaResults != null && scaResults.getPolicyEvaluations() != null && !scaResults.getPolicyEvaluations().isEmpty()) {
                policies.putAll(scaResults.getPolicyEvaluations().stream().filter(policy -> policy.getIsViolated()).collect(Collectors.toMap(PolicyEvaluation::getName, PolicyEvaluation::getId, (left, right) -> left)));
                policyViolated = policyViolated || policies.size() != 0;
            }
            if (scanSummary.isPolicyViolated()) {
                buildFailed = true;
                policyViolated = true;
            }
            String policyLabel = (policyViolatedCount += policies.size()) == 1 ? "Policy" : "Policies";
            templateData.put("policyLabel", policyLabel);
            templateData.put("policyViolatedCount", policyViolatedCount);
        }
        templateData.put("policyViolated", policyViolated);
        buildFailed = buildFailed || policyViolated;
        templateData.put("buildFailed", buildFailed);
        StringWriter writer = new StringWriter();
        template.process(templateData, (Writer)writer);
        return writer.toString();
    }

    private static DependencyScanResult resolveDependencyResult(OSAResults osaResults, AstScaResults scaResults) {
        DependencyScanResult dependencyScanResult = osaResults != null ? new DependencyScanResult(osaResults) : (scaResults != null ? new DependencyScanResult(scaResults) : null);
        return dependencyScanResult;
    }

    private static float calculateNewBarHeight(int newCount, int count, float totalHeight) {
        float highNewHeightPx = (float)newCount / (float)count * totalHeight;
        int minimalVisibilityHeight = 5;
        if (SummaryUtils.isNewNeedChange(totalHeight, highNewHeightPx, minimalVisibilityHeight)) {
            highNewHeightPx = minimalVisibilityHeight;
        }
        return highNewHeightPx;
    }

    private static boolean isNewNeedChange(float highTotalHeightPx, float highNewHeightPx, int minimalVisibilityHeight) {
        return highNewHeightPx > 0.0f && highNewHeightPx < (float)minimalVisibilityHeight && highTotalHeightPx > (float)(minimalVisibilityHeight * 2);
    }
}

